/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.util;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertexQuery;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.internal.RelationCategory;

public class VertexCentricEdgeIterable<R extends JanusGraphRelation>
implements Iterable<R> {
    private final Iterable<InternalVertex> vertices;
    private final RelationCategory relationCategory;

    public VertexCentricEdgeIterable(Iterable<InternalVertex> vertices, RelationCategory relationCategory) {
        Preconditions.checkArgument((vertices != null && relationCategory != null ? 1 : 0) != 0);
        this.vertices = vertices;
        this.relationCategory = relationCategory;
    }

    @Override
    public Iterator<R> iterator() {
        return new EdgeIterator();
    }

    private class EdgeIterator
    implements Iterator<R> {
        private final Iterator<InternalVertex> vertexIterator;
        private Iterator<JanusGraphRelation> currentOutEdges;
        private JanusGraphRelation nextEdge = null;

        public EdgeIterator() {
            this.vertexIterator = VertexCentricEdgeIterable.this.vertices.iterator();
            if (this.vertexIterator.hasNext()) {
                this.currentOutEdges = VertexCentricEdgeIterable.this.relationCategory.executeQuery((JanusGraphVertexQuery)this.vertexIterator.next().query().direction(Direction.OUT)).iterator();
                this.getNextEdge();
            }
        }

        private void getNextEdge() {
            assert (this.vertexIterator != null && this.currentOutEdges != null);
            this.nextEdge = null;
            while (this.nextEdge == null) {
                if (this.currentOutEdges.hasNext()) {
                    this.nextEdge = this.currentOutEdges.next();
                    break;
                }
                if (!this.vertexIterator.hasNext()) break;
                this.currentOutEdges = VertexCentricEdgeIterable.this.relationCategory.executeQuery((JanusGraphVertexQuery)this.vertexIterator.next().query().direction(Direction.OUT)).iterator();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextEdge != null;
        }

        @Override
        public R next() {
            if (this.nextEdge == null) {
                throw new NoSuchElementException();
            }
            JanusGraphRelation returnEdge = this.nextEdge;
            this.getNextEdge();
            return returnEdge;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

