/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.support.oauth.OAuthUtils;
import org.jasig.cas.support.oauth.services.OAuthRegisteredService;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public final class OAuth20AccessTokenController
extends AbstractController {
    private static Logger LOGGER = LoggerFactory.getLogger(OAuth20AccessTokenController.class);
    private final ServicesManager servicesManager;
    private final TicketRegistry ticketRegistry;
    private final long timeout;

    public OAuth20AccessTokenController(ServicesManager servicesManager, TicketRegistry ticketRegistry, long timeout) {
        this.servicesManager = servicesManager;
        this.ticketRegistry = ticketRegistry;
        this.timeout = timeout;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String redirectUri = request.getParameter("redirect_uri");
        LOGGER.debug("{} : {}", (Object)"redirect_uri", (Object)redirectUri);
        String clientId = request.getParameter("client_id");
        LOGGER.debug("{} : {}", (Object)"client_id", (Object)clientId);
        String clientSecret = request.getParameter("client_secret");
        String code = request.getParameter("code");
        LOGGER.debug("{} : {}", (Object)"code", (Object)code);
        boolean isVerified = this.verifyAccessTokenRequest(response, redirectUri, clientId, clientSecret, code);
        if (!isVerified) {
            return OAuthUtils.writeTextError(response, "invalid_request", 400);
        }
        ServiceTicket serviceTicket = (ServiceTicket)this.ticketRegistry.getTicket(code);
        if (serviceTicket == null || serviceTicket.isExpired()) {
            LOGGER.error("Code expired : {}", (Object)code);
            return OAuthUtils.writeTextError(response, "invalid_grant", 400);
        }
        TicketGrantingTicket ticketGrantingTicket = serviceTicket.getGrantingTicket();
        this.ticketRegistry.deleteTicket(serviceTicket.getId());
        response.setContentType("text/plain");
        int expires = (int)(this.timeout - (System.currentTimeMillis() - ticketGrantingTicket.getCreationTime()) / 1000L);
        String text = String.format("%s=%s&%s=%s", "access_token", ticketGrantingTicket.getId(), "expires", expires);
        LOGGER.debug("text : {}", (Object)text);
        return OAuthUtils.writeText(response, text, 200);
    }

    private boolean verifyAccessTokenRequest(HttpServletResponse response, String redirectUri, String clientId, String clientSecret, String code) {
        if (StringUtils.isBlank((String)clientId)) {
            LOGGER.error("Missing {}", (Object)"client_id");
            return false;
        }
        if (StringUtils.isBlank((String)redirectUri)) {
            LOGGER.error("Missing {}", (Object)"redirect_uri");
            return false;
        }
        if (StringUtils.isBlank((String)clientSecret)) {
            LOGGER.error("Missing {}", (Object)"client_secret");
            return false;
        }
        if (StringUtils.isBlank((String)code)) {
            LOGGER.error("Missing {}", (Object)"code");
            return false;
        }
        OAuthRegisteredService service = OAuthUtils.getRegisteredOAuthService(this.servicesManager, clientId);
        if (service == null) {
            LOGGER.error("Unknown {} : {}", (Object)"client_id", (Object)clientId);
            return false;
        }
        String serviceId = service.getServiceId();
        if (!redirectUri.matches(serviceId)) {
            LOGGER.error("Unsupported {} : {} for serviceId : {}", new Object[]{"redirect_uri", redirectUri, serviceId});
            return false;
        }
        if (!StringUtils.equals((String)service.getClientSecret(), (String)clientSecret)) {
            LOGGER.error("Wrong client secret for service {}", (Object)service);
            return false;
        }
        return true;
    }
}

