/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.web;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public final class OAuth20ProfileController
extends AbstractController {
    private static Logger LOGGER = LoggerFactory.getLogger(OAuth20ProfileController.class);
    private static final String ID = "id";
    private static final String ATTRIBUTES = "attributes";
    private final TicketRegistry ticketRegistry;
    private final JsonFactory jsonFactory = new JsonFactory((ObjectCodec)new ObjectMapper());

    public OAuth20ProfileController(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String accessToken = request.getParameter("access_token");
        LOGGER.debug("{} : {}", (Object)"access_token", (Object)accessToken);
        JsonGenerator jsonGenerator = this.jsonFactory.createJsonGenerator((Writer)response.getWriter());
        try {
            response.setContentType("application/json");
            if (StringUtils.isBlank((String)accessToken)) {
                LOGGER.error("Missing {}", (Object)"access_token");
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("error", "missing_accessToken");
                jsonGenerator.writeEndObject();
                ModelAndView modelAndView = null;
                return modelAndView;
            }
            TicketGrantingTicket ticketGrantingTicket = (TicketGrantingTicket)this.ticketRegistry.getTicket(accessToken);
            if (ticketGrantingTicket == null || ticketGrantingTicket.isExpired()) {
                LOGGER.error("expired accessToken : {}", (Object)accessToken);
                jsonGenerator.writeStartObject();
                jsonGenerator.writeStringField("error", "expired_accessToken");
                jsonGenerator.writeEndObject();
                ModelAndView modelAndView = null;
                return modelAndView;
            }
            Principal principal = ticketGrantingTicket.getAuthentication().getPrincipal();
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField(ID, principal.getId());
            jsonGenerator.writeArrayFieldStart(ATTRIBUTES);
            Map attributes = principal.getAttributes();
            for (String key : attributes.keySet()) {
                jsonGenerator.writeStartObject();
                jsonGenerator.writeObjectField(key, attributes.get(key));
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndArray();
            jsonGenerator.writeEndObject();
            ModelAndView modelAndView = null;
            return modelAndView;
        }
        finally {
            IOUtils.closeQuietly((Closeable)jsonGenerator);
            response.flushBuffer();
        }
    }
}

