/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import org.jasig.cas.web.flow.AbstractCasWebflowConfigurer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.webflow.engine.ActionState;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.execution.Action;

@Component(value="spnegoWebflowConfigurer")
public class SpengoWebflowConfigurer
extends AbstractCasWebflowConfigurer {
    @Value(value="${cas.spnego.hostname.client.action.strategy:hostnameSpnegoClientAction}")
    private String hostNameClientActionStrategy;

    protected void doInitialize() throws Exception {
        Flow flow = this.getLoginFlow();
        ActionState actionState = this.createActionState(flow, "startSpnegoAuthenticate", new Action[]{this.createEvaluateAction("negociateSpnego")});
        actionState.getTransitionSet().add(this.createTransition("success", "spnego"));
        ActionState spnego = this.createActionState(flow, "spnego", new Action[]{this.createEvaluateAction("spnego")});
        spnego.getTransitionSet().add(this.createTransition("success", "sendTicketGrantingTicket"));
        spnego.getTransitionSet().add(this.createTransition("error", this.getStartState(flow)));
        ActionState evaluateClientRequest = this.createActionState(flow, "evaluateClientRequest", new Action[]{this.createEvaluateAction("hostNameClientActionStrategy")});
        evaluateClientRequest.getTransitionSet().add(this.createTransition("yes", "startSpnegoAuthenticate"));
        evaluateClientRequest.getTransitionSet().add(this.createTransition("no", this.getStartState(flow)));
    }
}

