/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jspc.compiler.tomcat7;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspC;
import org.apache.jasper.compiler.Localizer;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tools.ant.BuildException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiThreadedJspC
extends JspC {
    private static final Log log = LogFactory.getLog(MultiThreadedJspC.class);
    private int threads = 1;
    private long compilationTimeoutMinutes = 30L;

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        this.threads = threads;
    }

    public long getCompilationTimeoutMinutes() {
        return this.compilationTimeoutMinutes;
    }

    public void setCompilationTimeoutMinutes(long compilationTimeoutMinutes) {
        this.compilationTimeoutMinutes = compilationTimeoutMinutes;
    }

    public void execute() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("execute() starting for " + this.pages.size() + " pages."));
        }
        try {
            if (this.uriRoot == null) {
                if (this.pages.size() == 0) {
                    throw new JasperException(Localizer.getMessage((String)"jsp.error.jspc.missingTarget"));
                }
                String firstJsp = (String)this.pages.get(0);
                File firstJspF = new File(firstJsp);
                if (!firstJspF.exists()) {
                    throw new JasperException(Localizer.getMessage((String)"jspc.error.fileDoesNotExist", (String)firstJsp));
                }
                this.locateUriRoot(firstJspF);
            }
            if (this.uriRoot == null) {
                throw new JasperException(Localizer.getMessage((String)"jsp.error.jspc.no_uriroot"));
            }
            File uriRootF = new File(this.uriRoot);
            if (!uriRootF.isDirectory()) {
                throw new JasperException(Localizer.getMessage((String)"jsp.error.jspc.uriroot_not_dir"));
            }
            if (this.context == null) {
                this.initServletContext();
            }
            if (this.pages.size() == 0) {
                this.scanFiles(uriRootF);
            }
            this.initWebXml();
            log.info((Object)("compiling with " + this.getThreads() + " threads"));
            ExecutorService executor = Executors.newFixedThreadPool(this.getThreads());
            final List<JasperException> errorCollector = Collections.synchronizedList(new ArrayList());
            for (String nextjsp : this.pages) {
                File fjsp = new File(nextjsp);
                if (!fjsp.isAbsolute()) {
                    fjsp = new File(uriRootF, nextjsp);
                }
                if (!fjsp.exists()) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn((Object)Localizer.getMessage((String)"jspc.error.fileDoesNotExist", (String)fjsp.toString()));
                    continue;
                }
                String s = fjsp.getAbsolutePath();
                if (s.startsWith(this.uriRoot)) {
                    nextjsp = s.substring(this.uriRoot.length());
                }
                if (nextjsp.startsWith("." + File.separatorChar)) {
                    nextjsp = nextjsp.substring(2);
                }
                final String jspToCompile = nextjsp;
                executor.execute(new Runnable(){

                    public void run() {
                        try {
                            MultiThreadedJspC.this.processFile(jspToCompile);
                        }
                        catch (JasperException je) {
                            errorCollector.add(je);
                        }
                    }
                });
            }
            executor.shutdown();
            executor.awaitTermination(this.compilationTimeoutMinutes, TimeUnit.MINUTES);
            if (errorCollector.size() > 0) {
                this.throwBuildException(errorCollector);
            }
            this.completeWebXml();
            if (this.addWebXmlMappings) {
                this.mergeIntoWebXml();
            }
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
        catch (JasperException je) {
            this.throwBuildException(Arrays.asList(je));
        }
        catch (InterruptedException e) {
            throw new BuildException((Throwable)e);
        }
        finally {
            if (this.loader != null) {
                LogFactory.release((ClassLoader)this.loader);
            }
        }
    }

    private void throwBuildException(List<JasperException> errorCollector) {
        StringBuilder errOut = new StringBuilder();
        for (JasperException je : errorCollector) {
            Throwable rootCause = je;
            while (rootCause instanceof JasperException && rootCause.getRootCause() != null) {
                rootCause = rootCause.getRootCause();
            }
            if (rootCause != errorCollector) {
                rootCause.printStackTrace();
            }
            errOut.append(rootCause.getMessage()).append('\n');
        }
        throw new BuildException(errOut.toString(), (Throwable)errorCollector.get(0));
    }
}

