/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jspc.compiler.tomcat7;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.codehaus.mojo.jspc.compiler.JspCompiler;
import org.codehaus.mojo.jspc.compiler.tomcat7.MultiThreadedJspC;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspCompilerImpl
implements JspCompiler {
    private final MultiThreadedJspC jspc = new MultiThreadedJspC();
    private boolean showSuccess = false;
    private boolean listErrors = false;

    public JspCompilerImpl() {
        this.jspc.setFailOnError(true);
    }

    public void setWebappDirectory(String webappDir) {
        this.jspc.setUriroot(webappDir);
    }

    public void setOutputDirectory(File outputDirectory) {
        this.jspc.setOutputDir(outputDirectory.getAbsolutePath());
    }

    public void setEncoding(String encoding) {
        this.jspc.setJavaEncoding(encoding);
    }

    public void setShowSuccess(boolean showSuccess) {
        this.showSuccess = showSuccess;
    }

    public void setListErrors(boolean listErrors) {
        this.listErrors = listErrors;
    }

    public void setWebFragmentFile(File webFragmentFile) {
        this.jspc.setWebXmlFragment(webFragmentFile.getAbsolutePath());
    }

    public void setPackageName(String packageName) {
        this.jspc.setPackage(packageName);
    }

    public void setClasspath(Iterable<String> classpathElements) {
        String classpath = StringUtils.join(classpathElements.iterator(), (String)File.pathSeparator);
        this.jspc.setClassPath(classpath);
    }

    public void setSmapDumped(boolean smapDumped) {
        this.jspc.setSmapDumped(smapDumped);
    }

    public void setSmapSuppressed(boolean smapSuppressed) {
        this.jspc.setSmapSuppressed(smapSuppressed);
    }

    public void setCompile(boolean compile) {
        this.jspc.setCompile(compile);
    }

    public void setValidateXml(boolean validateXml) {
        this.jspc.setValidateXml(validateXml);
    }

    public void setTrimSpaces(boolean trimSpaces) {
        this.jspc.setTrimSpaces(trimSpaces);
    }

    public void setErrorOnUseBeanInvalidClassAttribute(boolean error) {
        this.jspc.setErrorOnUseBeanInvalidClassAttribute(error);
    }

    public void setVerbose(int verbose) {
        this.jspc.setVerbose(verbose);
    }

    public void setCompilerSourceVM(String source) {
        this.jspc.setCompilerSourceVM(source);
    }

    public void setCompilerTargetVM(String target) {
        this.jspc.setCompilerTargetVM(target);
    }

    public void setCaching(boolean caching) {
        this.jspc.setCaching(caching);
    }

    public void setGenStringAsCharArray(boolean genStringAsCharArray) {
        this.jspc.setGenStringAsCharArray(genStringAsCharArray);
    }

    public void setPoolingEnabled(boolean poolingEnabled) {
        this.jspc.setPoolingEnabled(poolingEnabled);
    }

    public void setClassDebugInfo(boolean classDebugInfo) {
        this.jspc.setClassDebugInfo(classDebugInfo);
    }

    public void compile(Iterable<File> jspFiles) throws Exception {
        ArrayList<String> args = new ArrayList<String>();
        if (this.showSuccess) {
            args.add("-s");
        }
        if (this.listErrors) {
            args.add("-l");
        }
        for (File jspFile : jspFiles) {
            args.add(jspFile.getAbsolutePath());
        }
        this.jspc.setArgs(args.toArray(new String[args.size()]));
        this.jspc.execute();
    }

    public void setCompileThreads(int threads) {
        this.jspc.setThreads(threads);
    }

    public void setCompileTimeout(long timeout) {
        this.jspc.setCompilationTimeout(timeout);
    }
}

