/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import org.javers.common.collections.EnumerableFunction;
import org.javers.core.graph.AbstractSingleEdge;
import org.javers.core.graph.CdoFactory;
import org.javers.core.graph.MultiEdge;
import org.javers.core.graph.NodeReuser;
import org.javers.core.graph.ObjectNode;
import org.javers.core.graph.ShallowSingleEdge;
import org.javers.core.graph.SingleEdge;
import org.javers.core.metamodel.object.Cdo;
import org.javers.core.metamodel.object.EnumerationAwareOwnerContext;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.PropertyOwnerContext;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.ShallowReferenceType;
import org.javers.core.metamodel.type.TypeMapper;

class EdgeBuilder {
    private final TypeMapper typeMapper;
    private final NodeReuser nodeReuser;
    private final CdoFactory cdoFactory;

    EdgeBuilder(TypeMapper typeMapper, NodeReuser nodeReuser, CdoFactory cdoFactory) {
        this.typeMapper = typeMapper;
        this.nodeReuser = nodeReuser;
        this.cdoFactory = cdoFactory;
    }

    String graphType() {
        return this.cdoFactory.typeDesc();
    }

    AbstractSingleEdge buildSingleEdge(ObjectNode node, Property singleRef) {
        Object rawReference = node.getPropertyValue(singleRef);
        Cdo cdo = this.cdoFactory.create(rawReference, this.createOwnerContext(node, singleRef));
        if (!this.isShallowReference(singleRef, cdo)) {
            ObjectNode targetNode = this.buildNodeStubOrReuse(cdo);
            return new SingleEdge(singleRef, targetNode);
        }
        return new ShallowSingleEdge(singleRef, cdo);
    }

    private boolean isShallowReference(Property reference, Cdo target) {
        return reference.hasShallowReferenceAnn() || target.getManagedType() instanceof ShallowReferenceType;
    }

    private OwnerContext createOwnerContext(ObjectNode parentNode, Property property) {
        return new PropertyOwnerContext(parentNode.getGlobalId(), property.getName());
    }

    MultiEdge createMultiEdge(Property containerProperty, EnumerableType enumerableType, ObjectNode node) {
        MultiEdge multiEdge = new MultiEdge(containerProperty);
        OwnerContext owner = this.createOwnerContext(node, containerProperty);
        Object container = node.getPropertyValue(containerProperty);
        MultiEdgeContainerBuilderFunction edgeBuilder = null;
        if (enumerableType instanceof MapType) {
            edgeBuilder = new MultiEdgeMapBuilderFunction(multiEdge);
        } else if (enumerableType instanceof ContainerType) {
            edgeBuilder = new MultiEdgeContainerBuilderFunction(multiEdge);
        }
        enumerableType.map(container, edgeBuilder, owner);
        return multiEdge;
    }

    private ObjectNode buildNodeStubOrReuse(Cdo cdo) {
        if (this.nodeReuser.isReusable(cdo)) {
            return this.nodeReuser.getForReuse(cdo);
        }
        return this.buildNodeStub(cdo);
    }

    ObjectNode buildNodeStub(Cdo cdo) {
        ObjectNode newStub = new ObjectNode(cdo);
        this.nodeReuser.enqueueStub(newStub);
        return newStub;
    }

    private class MultiEdgeMapBuilderFunction
    extends MultiEdgeContainerBuilderFunction {
        public MultiEdgeMapBuilderFunction(MultiEdge multiEdge) {
            super(multiEdge);
        }

        @Override
        boolean isManagedPosition(Object input) {
            return EdgeBuilder.this.typeMapper.getJaversType(input.getClass()) instanceof ManagedType;
        }
    }

    private class MultiEdgeContainerBuilderFunction
    implements EnumerableFunction {
        private final MultiEdge multiEdge;

        public MultiEdgeContainerBuilderFunction(MultiEdge multiEdge) {
            this.multiEdge = multiEdge;
        }

        public Object apply(Object input, EnumerationAwareOwnerContext context) {
            if (!this.isManagedPosition(input)) {
                return input;
            }
            ObjectNode objectNode = EdgeBuilder.this.buildNodeStubOrReuse(EdgeBuilder.this.cdoFactory.create(input, context));
            this.multiEdge.addReferenceNode(objectNode);
            return input;
        }

        boolean isManagedPosition(Object input) {
            return true;
        }
    }
}

