/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.rest.resource;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionIsRunningException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobExecutionNotRunningException;
import javax.batch.operations.JobOperator;
import javax.batch.operations.JobRestartException;
import javax.batch.operations.JobSecurityException;
import javax.batch.operations.JobStartException;
import javax.batch.operations.NoSuchJobException;
import javax.batch.operations.NoSuchJobExecutionException;
import javax.batch.operations.NoSuchJobInstanceException;
import javax.batch.runtime.BatchRuntime;
import javax.batch.runtime.JobExecution;
import javax.batch.runtime.JobInstance;
import javax.batch.runtime.StepExecution;
import org.jberet.rest.entity.JobEntity;
import org.jberet.rest.entity.JobExecutionEntity;
import org.jberet.rest.entity.JobInstanceEntity;
import org.jberet.rest.entity.StepExecutionEntity;

final class JobService {
    private static final JobService instance = new JobService();
    private final JobOperator jobOperator = BatchRuntime.getJobOperator();

    private JobService() {
    }

    static JobService getInstance() {
        return instance;
    }

    JobExecutionEntity start(String jobXmlName, Properties jobParameters) throws JobStartException, JobSecurityException, NoSuchJobExecutionException {
        long jobExecutionId = this.jobOperator.start(jobXmlName, jobParameters);
        return new JobExecutionEntity(this.jobOperator.getJobExecution(jobExecutionId), this.jobOperator.getJobInstance(jobExecutionId).getInstanceId());
    }

    JobEntity[] getJobs() throws JobSecurityException {
        Set jobNames = this.jobOperator.getJobNames();
        JobEntity[] result = new JobEntity[jobNames.size()];
        int i = 0;
        for (String jobName : jobNames) {
            int jobInstanceCount = this.jobOperator.getJobInstanceCount(jobName);
            List runningExecutions = this.jobOperator.getRunningExecutions(jobName);
            JobEntity je = new JobEntity(jobName, jobInstanceCount, runningExecutions.size());
            result[i++] = je;
        }
        return result;
    }

    JobInstanceEntity[] getJobInstances(String jobName, int start, int count) throws NoSuchJobException, JobSecurityException {
        List jobInstances = this.jobOperator.getJobInstances(jobName, start, count);
        int len = jobInstances.size();
        JobInstanceEntity[] jobInstanceData = new JobInstanceEntity[len];
        for (int i = 0; i < len; ++i) {
            JobInstance e = (JobInstance)jobInstances.get(i);
            jobInstanceData[i] = new JobInstanceEntity(e, this.jobOperator.getJobExecutions(e));
        }
        return jobInstanceData;
    }

    public JobInstanceEntity getJobInstance(long executionId) throws NoSuchJobExecutionException, JobSecurityException {
        JobInstance jobInstance = this.jobOperator.getJobInstance(executionId);
        return new JobInstanceEntity(jobInstance, this.jobOperator.getJobExecutions(jobInstance));
    }

    int getJobInstanceCount(String jobName) throws NoSuchJobException, JobSecurityException {
        return this.jobOperator.getJobInstanceCount(jobName);
    }

    JobExecutionEntity getJobExecution(long jobExecutionId) throws NoSuchJobExecutionException, JobSecurityException {
        JobExecution jobExecution = this.jobOperator.getJobExecution(jobExecutionId);
        return new JobExecutionEntity(jobExecution, this.jobOperator.getJobInstance(jobExecutionId).getInstanceId());
    }

    public JobExecutionEntity[] getJobExecutions(int count, long jobInstanceId, long jobExecutionId1) throws NoSuchJobInstanceException, JobSecurityException {
        JobInstance jobInstance = null;
        if (jobExecutionId1 > 0L) {
            jobInstance = this.jobOperator.getJobInstance(jobExecutionId1);
        }
        List jobExecutions = this.jobOperator.getJobExecutions(jobInstance);
        int countAll = jobExecutions.size();
        if (count <= 0) {
            count = countAll;
        }
        JobExecutionEntity[] jobExecutionEntities = new JobExecutionEntity[count];
        int i = countAll - 1;
        for (int j = 0; j < count && i >= 0; --i, ++j) {
            JobExecution e = (JobExecution)jobExecutions.get(i);
            jobExecutionEntities[j] = new JobExecutionEntity(e, this.jobOperator.getJobInstance(e.getExecutionId()).getInstanceId());
        }
        return jobExecutionEntities;
    }

    void abandon(long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionIsRunningException, JobSecurityException {
        this.jobOperator.abandon(jobExecutionId);
    }

    void stop(long jobExecutionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException, JobSecurityException {
        this.jobOperator.stop(jobExecutionId);
    }

    JobExecutionEntity restart(long jobExecutionId, Properties restartParameters) throws JobExecutionAlreadyCompleteException, NoSuchJobExecutionException, JobExecutionNotMostRecentException, JobRestartException, JobSecurityException {
        long restartExecutionId = this.jobOperator.restart(jobExecutionId, restartParameters);
        return new JobExecutionEntity(this.jobOperator.getJobExecution(restartExecutionId), this.jobOperator.getJobInstance(restartExecutionId).getInstanceId());
    }

    JobExecutionEntity[] getRunningExecutions(String jobName) throws NoSuchJobException, JobSecurityException {
        List executionIds = this.jobOperator.getRunningExecutions(jobName);
        int len = executionIds.size();
        JobExecutionEntity[] runningExecutions = new JobExecutionEntity[len];
        for (int i = len - 1; i >= 0; --i) {
            long e = (Long)executionIds.get(i);
            runningExecutions[len - 1 - i] = new JobExecutionEntity(this.jobOperator.getJobExecution(e), this.jobOperator.getJobInstance(e).getInstanceId());
        }
        return runningExecutions;
    }

    StepExecutionEntity[] getStepExecutions(long jobExecutionId) throws NoSuchJobExecutionException, JobSecurityException {
        List stepExecutions = this.jobOperator.getStepExecutions(jobExecutionId);
        int len = stepExecutions.size();
        StepExecutionEntity[] stepExecutionData = new StepExecutionEntity[len];
        for (int i = 0; i < len; ++i) {
            stepExecutionData[i] = new StepExecutionEntity((StepExecution)stepExecutions.get(i));
        }
        return stepExecutionData;
    }
}

