/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.annotation.compiler;

import com.thoughtworks.qdox.model.AbstractJavaEntity;
import com.thoughtworks.qdox.model.DocletTag;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import org.jboss.annotation.factory.ast.ASTAnnotation;
import org.jboss.annotation.factory.ast.ASTStart;
import org.jboss.annotation.factory.ast.AnnotationParser;
import org.jboss.annotation.factory.ast.ParseException;

public class AnnotationDocletTag
implements DocletTag {
    private static final long serialVersionUID = 1L;
    private String name;
    private final String value;
    private final int lineNumber;
    private ASTAnnotation ast;
    private AbstractJavaEntity owner;

    public AnnotationDocletTag(String name, String value, int lineNumber) {
        this.name = name;
        this.value = value;
        this.lineNumber = lineNumber;
        if (name.startsWith("@")) {
            if (name.indexOf(40) != -1) {
                throw new RuntimeException("illegal annotation syntax for doclet at line number " + lineNumber + ".  You should have a space after the tag name otherwise the compiler messes up. " + name + " ***value=" + value);
            }
            AnnotationParser parser = new AnnotationParser((Reader)new StringReader(name + value));
            try {
                ASTStart start = parser.Start();
                this.ast = (ASTAnnotation)start.jjtGetChild(0);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            this.name = name.substring(1);
        }
    }

    public AnnotationDocletTag(String name, String value) {
        this(name, value, 0);
    }

    public ASTAnnotation getAnnotation() {
        return this.ast;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String[] getParameters() {
        return null;
    }

    public Map getNamedParameterMap() {
        return null;
    }

    public String getNamedParameter(String key) {
        return null;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public final AbstractJavaEntity getContext() {
        return this.owner;
    }

    public void setContext(AbstractJavaEntity owner) {
        this.owner = owner;
    }
}

