/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.expressions;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.CtClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterExpression {
    protected static final Pattern ALL = Pattern.compile("\\s*\\.\\.\\s*");
    protected static final Pattern PARAMS = Pattern.compile("\\s*(.*)\\s*");
    public String originalExpression;
    public Pattern[] parameterPatterns;
    public boolean isAll = false;

    protected static String simpleType(Class<?> type) {
        Class<?> ret = type;
        if (ret.isArray()) {
            Class<?> arr = ret;
            String array = "";
            while (arr.isArray()) {
                array = array + "[]";
                arr = arr.getComponentType();
            }
            return arr.getName() + array;
        }
        return ret.getName();
    }

    public ParameterExpression(String expression) {
        this.originalExpression = expression;
        Matcher all = ALL.matcher(expression);
        this.isAll = all.matches();
        if (!this.isAll) {
            Matcher params = PARAMS.matcher(expression);
            if (!params.matches()) {
                throw new RuntimeException("Illegal parameter list expression: " + expression);
            }
            StringTokenizer tokenizer = new StringTokenizer(expression, ",");
            ArrayList<Pattern> paramList = new ArrayList<Pattern>();
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                token = token.replaceAll("\\.", "\\\\.");
                token = token.replaceAll("\\*", ".*");
                token = token.replaceAll("\\[", "\\\\[");
                token = token.replaceAll("\\]", "\\\\]");
                paramList.add(Pattern.compile(token));
            }
            this.parameterPatterns = paramList.toArray(new Pattern[paramList.size()]);
        }
    }

    public boolean matches(Class<?>[] params) {
        if (this.isAll) {
            return true;
        }
        if (params.length != this.parameterPatterns.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            String asString = ParameterExpression.simpleType(params[i]);
            Matcher m = this.parameterPatterns[i].matcher(asString);
            if (m.matches()) continue;
            return false;
        }
        return true;
    }

    public boolean matches(CtClass[] params) {
        if (this.isAll) {
            return true;
        }
        if (params.length != this.parameterPatterns.length) {
            return false;
        }
        for (int i = 0; i < params.length; ++i) {
            String asString = params[i].getName();
            Matcher m = this.parameterPatterns[i].matcher(asString);
            if (m.matches()) continue;
            return false;
        }
        return true;
    }
}

