/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.container.glassfish.embedded_3_1;

import com.sun.enterprise.web.WebModule;
import java.io.File;
import java.net.URL;
import java.util.Map;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.embeddable.web.Context;
import org.glassfish.embeddable.web.VirtualServer;
import org.glassfish.embeddable.web.WebContainer;
import org.jboss.arquillian.container.glassfish.embedded_3_1.GlassFishConfiguration;
import org.jboss.arquillian.container.glassfish.embedded_3_1.ShrinkWrapUtil;
import org.jboss.arquillian.spi.client.container.DeployableContainer;
import org.jboss.arquillian.spi.client.container.DeploymentException;
import org.jboss.arquillian.spi.client.container.LifecycleException;
import org.jboss.arquillian.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.spi.client.protocol.metadata.Servlet;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishContainer
implements DeployableContainer<GlassFishConfiguration> {
    private static final String ADDRESS = "localhost";
    private GlassFishConfiguration configuration;
    private GlassFishRuntime glassfishRuntime;
    private GlassFish glassfish;

    public Class<GlassFishConfiguration> getConfigurationClass() {
        return GlassFishConfiguration.class;
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public void setup(GlassFishConfiguration configuration) {
        this.configuration = configuration;
        BootstrapProperties bootstrapProps = new BootstrapProperties();
        if (configuration.getInstallRoot() != null) {
            bootstrapProps.setInstallRoot(configuration.getInstallRoot());
        }
        try {
            this.glassfishRuntime = GlassFishRuntime.bootstrap((BootstrapProperties)bootstrapProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not setup GlassFish Embedded Bootstrap", e);
        }
        GlassFishProperties serverProps = new GlassFishProperties();
        if (configuration.getInstanceRoot() != null) {
            File instanceRoot = new File(configuration.getInstanceRoot());
            if (!instanceRoot.exists()) {
                instanceRoot.mkdirs();
            }
            serverProps.setInstanceRoot(configuration.getInstanceRoot());
        }
        if (configuration.getConfigurationXml() != null) {
            serverProps.setConfigFileURI(configuration.getConfigurationXml());
        }
        serverProps.setConfigFileReadOnly(configuration.isConfigurationReadOnly());
        serverProps.setPort("http-listener", configuration.getBindHttpPort());
        try {
            this.glassfish = this.glassfishRuntime.newGlassFish(serverProps);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not setup GlassFish Embedded Runtime", e);
        }
    }

    public void start() throws LifecycleException {
        try {
            this.glassfish.start();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start GlassFish Embedded", (Throwable)e);
        }
    }

    public void stop() throws LifecycleException {
        try {
            this.glassfish.stop();
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop GlassFish Embedded", (Throwable)e);
        }
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        String deploymentName = this.createDeploymentName(archive.getName());
        try {
            URL deploymentUrl = ShrinkWrapUtil.toURL(archive);
            this.glassfish.getDeployer().deploy(deploymentUrl.toURI(), new String[]{"--name", deploymentName});
        }
        catch (Exception e) {
            throw new DeploymentException("Could not deploy " + archive.getName(), (Throwable)e);
        }
        try {
            HTTPContext httpContext = new HTTPContext(ADDRESS, this.configuration.getBindHttpPort());
            this.findServlets(httpContext, deploymentName);
            return new ProtocolMetaData().addContext((Object)httpContext);
        }
        catch (GlassFishException e) {
            throw new DeploymentException("Could not probe GlassFish embedded for environment", (Throwable)e);
        }
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        try {
            this.glassfish.getDeployer().undeploy(this.createDeploymentName(archive.getName()), new String[0]);
        }
        catch (Exception e) {
            throw new DeploymentException("Could not undeploy " + archive.getName(), (Throwable)e);
        }
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new UnsupportedOperationException("Not implemented");
    }

    private String createDeploymentName(String archiveName) {
        return archiveName.substring(0, archiveName.lastIndexOf("."));
    }

    public void findServlets(HTTPContext httpContext, String deploymentName) throws GlassFishException {
        WebContainer webContainer = (WebContainer)this.glassfish.getService(WebContainer.class);
        for (VirtualServer server : webContainer.getVirtualServers()) {
            for (Context context : server.getContexts()) {
                if (context instanceof WebModule && !((WebModule)context).getID().startsWith(deploymentName)) continue;
                for (Map.Entry servletRegistration : context.getServletRegistrations().entrySet()) {
                    httpContext.add(new Servlet((String)servletRegistration.getKey(), context.getContextPath()));
                }
            }
        }
    }
}

