/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.List;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.drone.event.DroneConfigured;
import org.jboss.arquillian.drone.impl.DroneContext;
import org.jboss.arquillian.drone.impl.DroneRegistry;
import org.jboss.arquillian.drone.impl.MethodContext;
import org.jboss.arquillian.drone.impl.SecurityActions;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.test.spi.annotation.ClassScoped;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;

public class DroneConfigurator {
    @Inject
    @ClassScoped
    private InstanceProducer<DroneContext> droneContext;
    @Inject
    @ClassScoped
    private InstanceProducer<MethodContext> methodContext;
    @Inject
    private Instance<ArquillianDescriptor> arquillianDescriptor;
    @Inject
    private Instance<DroneRegistry> registry;
    @Inject
    private Event<DroneConfigured> afterConfiguration;

    public void configureDrone(@Observes BeforeClass event) {
        this.methodContext.set((Object)new MethodContext());
        List<Field> fields = SecurityActions.getFieldsWithAnnotation(event.getTestClass().getJavaClass(), Drone.class);
        if (fields.isEmpty()) {
            return;
        }
        this.droneContext.set((Object)new DroneContext());
        for (Field f : fields) {
            Class<?> typeClass = f.getType();
            Class<? extends Annotation> qualifier = SecurityActions.getQualifier(f);
            Configurator<?, ?> configurator = ((DroneRegistry)this.registry.get()).getConfiguratorFor(typeClass);
            if (configurator == null) {
                throw new IllegalArgumentException("No configurator was found for object of type " + typeClass.getName());
            }
            DroneConfiguration configuration = configurator.createConfiguration((ArquillianDescriptor)this.arquillianDescriptor.get(), qualifier);
            ((DroneContext)this.droneContext.get()).add(configuration.getClass(), qualifier, configuration);
            this.afterConfiguration.fire((Object)new DroneConfigured(f, qualifier, configuration));
        }
    }
}

