/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.config.descriptor.api.ArquillianDescriptor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.spi.Validate;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.drone.impl.DroneContext;
import org.jboss.arquillian.drone.impl.DroneRegistry;
import org.jboss.arquillian.drone.impl.MethodContext;
import org.jboss.arquillian.drone.impl.SecurityActions;
import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.test.spi.TestEnricher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneTestEnricher
implements TestEnricher {
    private static final Logger log = Logger.getLogger(DroneTestEnricher.class.getName());
    @Inject
    private Instance<DroneContext> droneContext;
    @Inject
    private Instance<MethodContext> methodContext;
    @Inject
    private Instance<ArquillianDescriptor> arquillianDescriptor;
    @Inject
    private Instance<DroneRegistry> registry;

    public void enrich(Object testCase) {
        List<Field> droneEnrichements = SecurityActions.getFieldsWithAnnotation(testCase.getClass(), Drone.class);
        if (!droneEnrichements.isEmpty()) {
            Validate.notNull((Object)this.droneContext.get(), (String)"Drone Test context should not be null");
            this.droneEnrichement(testCase, droneEnrichements);
        }
    }

    public Object[] resolve(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        Object[] resolution = new Object[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!SecurityActions.isAnnotationPresent(parameterAnnotations[i], Drone.class)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Resolving method " + method.getName() + " argument at position " + i);
            }
            Validate.notNull((Object)this.registry.get(), (String)"Drone registry should not be null");
            Validate.notNull((Object)this.arquillianDescriptor.get(), (String)"ArquillianDescriptor should not be null");
            Class<? extends Annotation> qualifier = SecurityActions.getQualifier(parameterAnnotations[i]);
            resolution[i] = this.constructDrone(method, parameterTypes[i], qualifier);
        }
        return resolution;
    }

    private void droneEnrichement(Object testCase, List<Field> fields) {
        try {
            for (Field f : fields) {
                if (f.get(testCase) != null) {
                    return;
                }
                Class<?> typeClass = f.getType();
                Class<? extends Annotation> qualifier = SecurityActions.getQualifier(f);
                Object value = ((DroneContext)this.droneContext.get()).get(typeClass, qualifier);
                if (value == null) {
                    throw new IllegalArgumentException("Retrieved a null from context, which is not a valid Drone browser object");
                }
                f.set(testCase, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not enrich test with Drone members", e);
        }
    }

    private Object constructDrone(Method method, Class<?> type, Class<? extends Annotation> qualifier) {
        DroneRegistry regs = (DroneRegistry)this.registry.get();
        ArquillianDescriptor desc = (ArquillianDescriptor)this.arquillianDescriptor.get();
        Configurator<?, ?> configurator = regs.getConfiguratorFor(type);
        Instantiator<?, ?> instantiator = regs.getInstantiatorFor(type);
        DroneContext dc = ((MethodContext)this.methodContext.get()).getOrCreate(method);
        DroneConfiguration configuration = configurator.createConfiguration(desc, qualifier);
        dc.add(configuration.getClass(), qualifier, configuration);
        Object instance = instantiator.createInstance(configuration);
        dc.add(type, qualifier, instance);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Stored method lifecycle based Drone instance, type: " + type.getName() + ", qualifier: " + qualifier.getName() + ", instanceClass: " + instance.getClass());
        }
        return instance;
    }
}

