/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.drone.impl.DroneContext;
import org.jboss.arquillian.drone.impl.MethodContext;
import org.jboss.arquillian.drone.impl.SecurityActions;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DroneRegistry;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneDestructor {
    private static final Logger log = Logger.getLogger(DroneDestructor.class.getName());
    @Inject
    private Instance<DroneRegistry> registry;

    public void destroyClassScopedDrone(@Observes AfterClass event, DroneContext droneContext) {
        Class clazz = event.getTestClass().getJavaClass();
        for (Field f : SecurityActions.getFieldsWithAnnotation(clazz, Drone.class)) {
            Class<?> typeClass = f.getType();
            Class<? extends Annotation> qualifier = SecurityActions.getQualifier(f);
            Destructor destructor = this.getDestructorFor(typeClass);
            Object instance = droneContext.get(typeClass, qualifier);
            if (instance != null) {
                destructor.destroyInstance(instance);
            }
            droneContext.remove(typeClass, qualifier);
        }
    }

    public void destroyMethodScopedDrone(@Observes After event, MethodContext droneMethodContext) {
        Method method = event.getTestMethod();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!SecurityActions.isAnnotationPresent(parameterAnnotations[i], Drone.class)) continue;
            Class<? extends Annotation> qualifier = SecurityActions.getQualifier(parameterAnnotations[i]);
            Destructor destructor = this.getDestructorFor(parameterTypes[i]);
            Object instance = droneMethodContext.get(parameterTypes[i], qualifier);
            if (instance != null) {
                destructor.destroyInstance(instance);
            }
            droneMethodContext.remove(parameterTypes[i], qualifier);
        }
    }

    private Destructor getDestructorFor(Class<?> typeClass) {
        Destructor destructor = (Destructor)((DroneRegistry)this.registry.get()).getEntryFor(typeClass, Destructor.class);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Using destructor defined in class: " + destructor.getClass().getName() + ", with precedence " + destructor.getPrecedence());
        }
        return destructor;
    }
}

