/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.drone.event.DroneConfigured;
import org.jboss.arquillian.drone.event.MethodDroneConfigured;
import org.jboss.arquillian.drone.impl.DroneContext;
import org.jboss.arquillian.drone.impl.MethodContext;
import org.jboss.arquillian.drone.spi.DroneConfiguration;
import org.jboss.arquillian.drone.spi.DroneRegistry;
import org.jboss.arquillian.drone.spi.Instantiator;

public class DroneCreator {
    private static final Logger log = Logger.getLogger(DroneCreator.class.getName());

    public void createWebTestBrowser(@Observes DroneConfigured event, DroneRegistry registry, DroneContext droneContext) {
        Field field = event.getInjected();
        Class<?> typeClass = field.getType();
        Class<? extends Annotation> qualifier = event.getQualifier();
        DroneConfiguration<?> configuration = event.getConfiguration();
        Instantiator instantiator = (Instantiator)registry.getEntryFor(typeClass, Instantiator.class);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Using instantiator defined in class: " + instantiator.getClass().getName() + ", with precedence " + instantiator.getPrecedence());
        }
        droneContext.add(typeClass, qualifier, instantiator.createInstance(configuration));
    }

    public void createWebTestBrowser(@Observes MethodDroneConfigured event, DroneRegistry registry, MethodContext droneMethodContext) {
        Class<?> typeClass = event.getDroneType();
        Class<? extends Annotation> qualifier = event.getQualifier();
        DroneConfiguration<?> configuration = event.getConfiguration();
        Instantiator instantiator = (Instantiator)registry.getEntryFor(typeClass, Instantiator.class);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Using instantiator defined in class: " + instantiator.getClass().getName() + ", with precedence " + instantiator.getPrecedence());
        }
        droneMethodContext.add(typeClass, qualifier, instantiator.createInstance(configuration));
    }
}

