/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.core.spi.ServiceLoader;
import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.drone.impl.SecurityActions;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.DroneContext;
import org.jboss.arquillian.drone.spi.DroneRegistry;
import org.jboss.arquillian.drone.spi.InstanceOrCallableInstance;
import org.jboss.arquillian.drone.spi.event.AfterDroneDestroyed;
import org.jboss.arquillian.drone.spi.event.BeforeDroneDestroyed;
import org.jboss.arquillian.drone.spi.event.DroneLifecycleEvent;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroneDestructor {
    private static final Logger log = Logger.getLogger(DroneDestructor.class.getName());
    @Inject
    private Instance<ServiceLoader> serviceLoader;
    @Inject
    private Instance<DroneRegistry> registry;
    @Inject
    private Event<DroneLifecycleEvent> droneLifecycleEvent;

    public void destroyClassScopedDrone(@Observes AfterClass event, DroneContext droneContext) {
        Class clazz = event.getTestClass().getJavaClass();
        for (Field f : SecurityActions.getFieldsWithAnnotation(clazz, Drone.class)) {
            Class<?> droneType = f.getType();
            Class<? extends Annotation> qualifier = SecurityActions.getQualifier(f);
            Destructor destructor = this.getDestructorFor(droneType);
            InstanceOrCallableInstance instance = droneContext.get(droneType, qualifier);
            if (instance == null) continue;
            this.droneLifecycleEvent.fire((Object)new BeforeDroneDestroyed(instance, droneType, qualifier));
            this.destroyInstanceIfInstantiated(destructor, instance, droneType, qualifier);
            droneContext.remove(droneType, qualifier);
            this.droneLifecycleEvent.fire((Object)new AfterDroneDestroyed(droneType, qualifier));
        }
    }

    public void destroyMethodScopedDrone(@Observes After event, DroneContext droneContext) {
        Method method = event.getTestMethod();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (!SecurityActions.isAnnotationPresent(parameterAnnotations[i], Drone.class)) continue;
            Class<? extends Annotation> qualifier = SecurityActions.getQualifier(parameterAnnotations[i]);
            Class<?> droneType = parameterTypes[i];
            Destructor destructor = this.getDestructorFor(droneType);
            InstanceOrCallableInstance instance = droneContext.get(droneType, qualifier);
            if (instance == null) continue;
            this.droneLifecycleEvent.fire((Object)new BeforeDroneDestroyed(instance, droneType, qualifier));
            this.destroyInstanceIfInstantiated(destructor, instance, droneType, qualifier);
            droneContext.remove(droneType, qualifier);
            this.droneLifecycleEvent.fire((Object)new AfterDroneDestroyed(droneType, qualifier));
        }
    }

    private Destructor getDestructorFor(Class<?> typeClass) {
        Destructor destructor = (Destructor)((DroneRegistry)this.registry.get()).getEntryFor(typeClass, Destructor.class);
        if (log.isLoggable(Level.FINE)) {
            log.fine("Using destructor defined in class: " + destructor.getClass().getName() + ", with precedence " + destructor.getPrecedence());
        }
        return destructor;
    }

    private void destroyInstanceIfInstantiated(Destructor destructor, InstanceOrCallableInstance instance, Class<?> droneType, Class<? extends Annotation> qualifier) {
        try {
            destructor.destroyInstance(instance.asInstance(droneType));
        }
        catch (IllegalStateException e) {
            log.log(Level.WARNING, "Ignoring destruction of the instance {0} @{1}, it was not instantiated previously.", new Object[]{droneType.getSimpleName(), qualifier.getSimpleName()});
        }
    }
}

