/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.binary.downloading.source;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.net.URI;
import java.util.Iterator;
import java.util.logging.Logger;
import org.apache.http.client.utils.URIBuilder;
import org.jboss.arquillian.drone.webdriver.binary.downloading.ExternalBinary;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.ExternalBinarySource;
import org.jboss.arquillian.drone.webdriver.utils.HttpUtils;

public abstract class GitHubSource
implements ExternalBinarySource {
    private Logger log = Logger.getLogger(GitHubSource.class.toString());
    private String projectUrl;
    private String latestUrl = "/releases/latest";
    private String releasesUrl = "/releases";
    private String tagNameKey = "tag_name";
    private String idKey = "id";
    private String assetNameKey = "name";
    private String browserDownloadUrlKey = "browser_download_url";
    private String assetsKey = "assets";
    private ExternalBinary binaryRelease;

    public GitHubSource(String organization, String project) {
        this.projectUrl = String.format("https://api.github.com/repos/%s/%s", organization, project);
    }

    @Override
    public ExternalBinary getLatestRelease() throws Exception {
        JsonObject latestRelease = this.sentGetRequest(this.projectUrl + this.latestUrl, false).getAsJsonObject();
        String tagName = latestRelease.get(this.tagNameKey).getAsString();
        String id = latestRelease.get(this.idKey).getAsString();
        this.binaryRelease = new ExternalBinary(tagName);
        this.setAssets(latestRelease, id);
        return this.binaryRelease;
    }

    @Override
    public ExternalBinary getReleaseForVersion(String version) throws Exception {
        JsonArray releases = this.sentGetRequest(this.projectUrl + this.releasesUrl, true).getAsJsonArray();
        Iterator iterator = releases.iterator();
        while (iterator.hasNext()) {
            JsonObject releaseObject = ((JsonElement)iterator.next()).getAsJsonObject();
            String releaseTagName = releaseObject.get(this.tagNameKey).getAsString();
            if (!version.equals(releaseTagName)) continue;
            this.binaryRelease = new ExternalBinary(releaseTagName);
            String id = releaseObject.get(this.idKey).getAsString();
            this.setAssets(releaseObject, id);
            return this.binaryRelease;
        }
        this.log.warning("There wasn't found any release for the version: " + version + " in the repository: " + this.projectUrl);
        return null;
    }

    protected abstract String getExpectedFileNameRegex();

    private void setAssets(JsonObject releaseObject, String releaseId) throws Exception {
        JsonArray assets = releaseObject.get(this.assetsKey).getAsJsonArray();
        Iterator iterator = assets.iterator();
        while (iterator.hasNext()) {
            JsonObject asset = ((JsonElement)iterator.next()).getAsJsonObject();
            String name = asset.get(this.assetNameKey).getAsString();
            if (!name.matches(this.getExpectedFileNameRegex())) continue;
            String browserDownloadUrl = asset.get(this.browserDownloadUrlKey).getAsString();
            this.binaryRelease.setUrl(browserDownloadUrl);
            break;
        }
    }

    private JsonElement sentGetRequest(String url, boolean withPagination) throws Exception {
        JsonElement result = this.sentGetRequestWithPagination(url, 1, JsonElement.class);
        if (result.isJsonArray()) {
            JsonArray page;
            JsonArray resultArray = result.getAsJsonArray();
            int i = 2;
            while ((page = this.sentGetRequestWithPagination(url, i, JsonArray.class)).size() != 0) {
                resultArray.addAll(page);
                if (!withPagination) break;
                ++i;
            }
            return resultArray;
        }
        return result;
    }

    private <T> T sentGetRequestWithPagination(String url, int pageNumber, Class<T> expectedType) throws Exception {
        URI uri = new URIBuilder(url).setParameter("page", String.valueOf(pageNumber)).build();
        String json = HttpUtils.sentGetRequest(uri.toString());
        Gson gson = new Gson();
        return (T)gson.fromJson(json, expectedType);
    }

    public ExternalBinary getBinaryRelease() {
        return this.binaryRelease;
    }
}

