/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.binary.downloading.source;

import java.io.StringReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.arquillian.drone.webdriver.binary.downloading.ExternalBinary;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.ExternalBinarySource;
import org.jboss.arquillian.drone.webdriver.utils.HttpUtils;
import org.jboss.arquillian.drone.webdriver.utils.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class GoogleStorageSource
implements ExternalBinarySource {
    private Logger log = Logger.getLogger(GoogleStorageSource.class.toString());
    private String storageUrl;
    private String urlToLatestRelease;
    private ArrayList<Content> contents;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private String latestVersion;

    public GoogleStorageSource(String storageUrl) {
        this.storageUrl = storageUrl;
    }

    public GoogleStorageSource(String storageUrl, String urlToLatestRelease) {
        this.urlToLatestRelease = urlToLatestRelease;
        this.storageUrl = storageUrl;
    }

    @Override
    public ExternalBinary getLatestRelease() throws Exception {
        if (this.urlToLatestRelease != null) {
            this.latestVersion = StringUtils.trimMultiline(HttpUtils.sentGetRequest(this.urlToLatestRelease));
        } else {
            this.retrieveContents();
        }
        return this.getReleaseForVersion(this.latestVersion);
    }

    private void retrieveContents() throws Exception {
        if (this.contents == null) {
            this.contents = new ArrayList();
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(HttpUtils.sentGetRequest(this.storageUrl)));
            Document doc = db.parse(is);
            NodeList contentNodes = ((Element)doc.getFirstChild()).getElementsByTagName("Contents");
            for (int i = 0; i < contentNodes.getLength(); ++i) {
                Element item = (Element)contentNodes.item(i);
                Content content = new Content();
                String key = this.getContentOfFirstElement(item, "Key");
                if (!key.contains("/")) continue;
                content.setKey(key);
                content.setLastModified(this.getContentOfFirstElement(item, "LastModified"));
                content.setDirectory(key.substring(0, key.indexOf("/")));
                this.contents.add(content);
            }
        }
    }

    private Date parseDate(String date, String key) {
        try {
            return this.dateFormat.parse(date);
        }
        catch (ParseException e) {
            this.log.warning("Date " + date + " of content " + this.storageUrl + key + " could not have been parsed. This content will be omitted. See the exception msg: " + e.getMessage());
            return null;
        }
    }

    private String getContentOfFirstElement(Element element, String tagName) {
        NodeList elementsByTagName = element.getElementsByTagName(tagName);
        if (elementsByTagName.getLength() == 0) {
            return "";
        }
        return elementsByTagName.item(0).getTextContent();
    }

    @Override
    public ExternalBinary getReleaseForVersion(String requiredVersion) throws Exception {
        this.retrieveContents();
        List<Content> matched = this.contents.stream().filter(content -> content.getKey().matches(this.getExpectedKeyRegex(requiredVersion, content.getDirectory()))).collect(Collectors.toList());
        if (matched.size() == 0) {
            throw new IllegalStateException("There wasn't found any binary with the key matching regex " + this.getExpectedKeyRegex(requiredVersion, "directory") + " in the storage: " + this.storageUrl);
        }
        if (requiredVersion != null) {
            return new ExternalBinary(requiredVersion, this.storageUrl + matched.get(0).getKey());
        }
        Content latestContent = this.findLatestContent(matched);
        return new ExternalBinary(latestContent.getDirectory(), this.storageUrl + latestContent.getKey());
    }

    private Content findLatestContent(List<Content> matched) {
        return (Content)matched.stream().sorted((c1, c2) -> {
            Date c1Date = this.parseDate(c1.getLastModified(), c1.getKey());
            Date c2Date = this.parseDate(c2.getLastModified(), c2.getKey());
            if (c1Date == null) {
                return -1;
            }
            if (c2Date == null) {
                return 1;
            }
            return Long.compare(c2Date.getTime(), c1Date.getTime());
        }).findFirst().get();
    }

    protected abstract String getExpectedKeyRegex(String var1, String var2);

    class Content {
        private String key;
        private String directory;
        private String lastModified;

        Content() {
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getLastModified() {
            return this.lastModified;
        }

        public void setLastModified(String lastModified) {
            this.lastModified = lastModified;
        }

        public String getDirectory() {
            return this.directory;
        }

        public void setDirectory(String directory) {
            this.directory = directory;
        }
    }
}

