/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.binary.handler;

import java.io.File;
import java.net.URL;
import java.util.logging.Logger;
import org.jboss.arquillian.drone.webdriver.binary.BinaryFilesUtils;
import org.jboss.arquillian.drone.webdriver.binary.downloading.Downloader;
import org.jboss.arquillian.drone.webdriver.binary.downloading.ExternalBinary;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.ExternalBinarySource;
import org.jboss.arquillian.drone.webdriver.binary.handler.BinaryHandler;
import org.jboss.arquillian.drone.webdriver.utils.Constants;
import org.jboss.arquillian.drone.webdriver.utils.PropertySecurityAction;
import org.jboss.arquillian.drone.webdriver.utils.Validate;
import org.openqa.selenium.remote.DesiredCapabilities;

public abstract class AbstractBinaryHandler
implements BinaryHandler {
    private Logger log = Logger.getLogger(this.getClass().toString());
    public static final String DOWNLOAD_BINARIES_PROPERTY = "downloadBinaries";

    @Override
    public String checkAndSetBinary(boolean performExecutableValidations) {
        String downloadBinaries;
        String binary = PropertySecurityAction.getProperty(this.getSystemBinaryProperty());
        if (Validate.empty(binary)) {
            binary = PropertySecurityAction.getProperty(this.getBinaryProperty());
        }
        if (Validate.empty(binary) && !Validate.empty(this.getBinaryProperty())) {
            binary = (String)this.getCapabilities().getCapability(this.getBinaryProperty());
        }
        if (Validate.empty(binary) && (Validate.empty(downloadBinaries = (String)this.getCapabilities().getCapability(DOWNLOAD_BINARIES_PROPERTY)) || !downloadBinaries.toLowerCase().trim().equals("false") && !downloadBinaries.toLowerCase().trim().equals("no"))) {
            try {
                binary = this.downloadAndPrepare().toString();
            }
            catch (Exception e) {
                throw new IllegalStateException("Something bad happened when Drone was trying to download and prepare a binary. For more information see the cause.", e);
            }
        }
        this.setBinaryAsSystemProperty(performExecutableValidations, binary);
        return binary;
    }

    protected void setBinaryAsSystemProperty(boolean performExecutableValidations, String binary) {
        if (Validate.nonEmpty(binary) && Validate.nonEmpty(this.getSystemBinaryProperty())) {
            if (performExecutableValidations) {
                Validate.isExecutable(binary, "The binary must point to an executable file, " + binary);
            }
            PropertySecurityAction.setProperty(this.getSystemBinaryProperty(), binary);
        }
    }

    @Override
    public File downloadAndPrepare() throws Exception {
        String url = null;
        if (!Validate.empty(this.getUrlToDownloadProperty())) {
            url = (String)this.getCapabilities().getCapability(this.getUrlToDownloadProperty());
        }
        String desiredVersion = null;
        if (!Validate.empty(this.getDesiredVersionProperty())) {
            desiredVersion = (String)this.getCapabilities().getCapability(this.getDesiredVersionProperty());
        }
        if (Validate.nonEmpty(url)) {
            if (Validate.empty(desiredVersion)) {
                return this.downloadAndPrepare(null, url);
            }
            return this.downloadAndPrepare(this.createAndGetCacheDirectory(desiredVersion), url);
        }
        if (this.getExternalBinarySource() == null) {
            return null;
        }
        ExternalBinary release = null;
        release = Validate.nonEmpty(desiredVersion) ? this.getExternalBinarySource().getReleaseForVersion(desiredVersion) : this.getExternalBinarySource().getLatestRelease();
        return this.downloadAndPrepare(this.createAndGetCacheDirectory(release.getVersion()), release.getUrl());
    }

    protected File downloadAndPrepare(File targetDir, String from) throws Exception {
        return this.downloadAndPrepare(targetDir, new URL(from));
    }

    protected File downloadAndPrepare(File targetDir, URL from) throws Exception {
        File downloaded = Downloader.download(targetDir, from);
        File extraction = BinaryFilesUtils.extract(downloaded);
        File[] files = extraction.listFiles(file -> file.isFile());
        if (files.length == 0) {
            throw new IllegalStateException("The number of extracted files in the directory " + extraction + " is 0. There is no file to use");
        }
        return this.markAsExecutable(files[0]);
    }

    protected File markAsExecutable(File binaryFile) {
        if (!Validate.executable(binaryFile.getAbsolutePath())) {
            this.log.info("marking binary file: " + binaryFile.getPath() + " as executable");
            try {
                binaryFile.setExecutable(true);
            }
            catch (SecurityException se) {
                this.log.severe("The downloaded binary: " + binaryFile + " could not be set as executable. This may cause additional problems.");
            }
        }
        return binaryFile;
    }

    private File createAndGetCacheDirectory(String subdirectory) {
        String dirPath = Constants.ARQUILLIAN_DRONE_CACHE_DIRECTORY + this.getArquillianCacheSubdirectory() + (subdirectory == null ? "" : File.separator + subdirectory);
        File dir = new File(dirPath);
        dir.mkdirs();
        return dir;
    }

    protected abstract String getBinaryProperty();

    @Override
    public abstract String getSystemBinaryProperty();

    protected abstract String getArquillianCacheSubdirectory();

    protected abstract String getDesiredVersionProperty();

    protected abstract String getUrlToDownloadProperty();

    protected abstract ExternalBinarySource getExternalBinarySource();

    protected abstract DesiredCapabilities getCapabilities();
}

