/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.binary.handler;

import java.io.File;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.ExternalBinarySource;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.SeleniumGoogleStorageSource;
import org.jboss.arquillian.drone.webdriver.binary.handler.AbstractBinaryHandler;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.phantom.resolver.maven.PlatformUtils;
import org.openqa.selenium.remote.DesiredCapabilities;

public class InternetExplorerBinaryHandler
extends AbstractBinaryHandler {
    public static final String IE_SYSTEM_DRIVER_BINARY_PROPERTY = "webdriver.ie.driver";
    private static final String IE_DRIVER_BINARY_PROPERTY = "ieDriverBinary";
    private static final String IE_DRIVER_VERSION_PROPERTY = "ieDriverVersion";
    private static final String IE_DRIVER_URL_PROPERTY = "ieDriverUrl";
    private DesiredCapabilities capabilities;

    public InternetExplorerBinaryHandler(DesiredCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    protected String getArquillianCacheSubdirectory() {
        return new BrowserCapabilitiesList.InternetExplorer().getReadableName();
    }

    @Override
    protected String getDesiredVersionProperty() {
        return IE_DRIVER_VERSION_PROPERTY;
    }

    @Override
    protected String getUrlToDownloadProperty() {
        return IE_DRIVER_URL_PROPERTY;
    }

    @Override
    protected ExternalBinarySource getExternalBinarySource() {
        return new IeStorageSource((String)this.capabilities.getCapability(IE_DRIVER_VERSION_PROPERTY));
    }

    @Override
    protected DesiredCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    protected String getBinaryProperty() {
        return IE_DRIVER_BINARY_PROPERTY;
    }

    @Override
    public String getSystemBinaryProperty() {
        return IE_SYSTEM_DRIVER_BINARY_PROPERTY;
    }

    @Override
    public File downloadAndPrepare() throws Exception {
        return super.downloadAndPrepare();
    }

    static class IeStorageSource
    extends SeleniumGoogleStorageSource {
        private String version;

        protected IeStorageSource(String version) {
            this.version = version;
        }

        @Override
        protected String getExpectedKeyRegex(String requiredVersion, String directory) {
            StringBuffer regexBuffer = new StringBuffer("%s/IEDriverServer_");
            if (PlatformUtils.is32()) {
                regexBuffer.append("Win32");
            } else {
                regexBuffer.append("x64");
            }
            regexBuffer.append("_%s.zip");
            String regex = this.version == null ? String.format(regexBuffer.toString(), directory, directory + ".*") : String.format(regexBuffer.toString(), this.getDirectoryFromFullVersion(this.version), this.version);
            return regex;
        }
    }
}

