/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.binary.handler;

import java.util.logging.Logger;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.ExternalBinarySource;
import org.jboss.arquillian.drone.webdriver.binary.downloading.source.SeleniumGoogleStorageSource;
import org.jboss.arquillian.drone.webdriver.binary.handler.AbstractBinaryHandler;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SeleniumServerBinaryHandler
extends AbstractBinaryHandler {
    private static final String SELENIUM_SERVER_SYSTEM_DRIVER_BINARY_PROPERTY = "selenium.server.binary.path";
    private static final String SELENIUM_SERVER_DRIVER_BINARY_PROPERTY = "seleniumServerBinary";
    public static final String SELENIUM_SERVER_VERSION_PROPERTY = "seleniumServerVersion";
    private static final String SELENIUM_SERVER_URL_PROPERTY = "seleniumServerUrl";
    private Logger log = Logger.getLogger(SeleniumServerBinaryHandler.class.toString());
    private DesiredCapabilities capabilities;

    public SeleniumServerBinaryHandler(DesiredCapabilities capabilities) {
        this.capabilities = capabilities;
    }

    @Override
    protected String getArquillianCacheSubdirectory() {
        return "selenium-server";
    }

    @Override
    protected String getDesiredVersionProperty() {
        return SELENIUM_SERVER_VERSION_PROPERTY;
    }

    @Override
    protected String getUrlToDownloadProperty() {
        return SELENIUM_SERVER_URL_PROPERTY;
    }

    @Override
    protected ExternalBinarySource getExternalBinarySource() {
        return new SeleniumServerStorage((String)this.capabilities.getCapability(SELENIUM_SERVER_VERSION_PROPERTY));
    }

    @Override
    protected DesiredCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    protected String getBinaryProperty() {
        return SELENIUM_SERVER_DRIVER_BINARY_PROPERTY;
    }

    @Override
    public String getSystemBinaryProperty() {
        return SELENIUM_SERVER_SYSTEM_DRIVER_BINARY_PROPERTY;
    }

    static class SeleniumServerStorage
    extends SeleniumGoogleStorageSource {
        private String version;

        SeleniumServerStorage(String version) {
            this.version = version;
        }

        @Override
        protected String getExpectedKeyRegex(String requiredVersion, String directory) {
            StringBuffer regexBuffer = new StringBuffer("%s/selenium-server-standalone-");
            regexBuffer.append("%s.jar");
            String regex = this.version == null ? String.format(regexBuffer.toString(), directory, directory + ".*") : String.format(regexBuffer.toString(), this.getDirectoryFromFullVersion(this.version), this.version);
            return regex;
        }
    }
}

