/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory;

import org.jboss.arquillian.drone.spi.Configurator;
import org.jboss.arquillian.drone.spi.Destructor;
import org.jboss.arquillian.drone.spi.Instantiator;
import org.jboss.arquillian.drone.webdriver.configuration.WebDriverConfiguration;
import org.jboss.arquillian.drone.webdriver.factory.AbstractWebDriverFactory;
import org.jboss.arquillian.drone.webdriver.factory.BrowserCapabilitiesList;
import org.jboss.arquillian.drone.webdriver.factory.SecurityActions;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.safari.SafariDriver;

public class SafariDriverFactory
extends AbstractWebDriverFactory<SafariDriver>
implements Configurator<SafariDriver, WebDriverConfiguration>,
Instantiator<SafariDriver, WebDriverConfiguration>,
Destructor<SafariDriver> {
    private static final String BROWSER_CAPABILITIES = new BrowserCapabilitiesList.Safari().getReadableName();

    public int getPrecedence() {
        return 0;
    }

    public void destroyInstance(SafariDriver instance) {
        instance.quit();
    }

    public SafariDriver createInstance(WebDriverConfiguration configuration) {
        Capabilities capabilities = this.getCapabilities(configuration, true);
        return SecurityActions.newInstance(configuration.getImplementationClass(), new Class[]{Capabilities.class}, new Object[]{capabilities}, SafariDriver.class);
    }

    public Capabilities getCapabilities(WebDriverConfiguration configuration, boolean performValidations) {
        return configuration.getCapabilities();
    }

    @Override
    protected String getDriverReadableName() {
        return BROWSER_CAPABILITIES;
    }
}

