/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.factory.remote.reusable;

import java.lang.reflect.Field;
import java.net.URL;
import org.jboss.arquillian.drone.webdriver.factory.remote.reusable.UnableReuseSessionException;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.SessionId;

public class ReusableRemoteWebDriver
extends RemoteWebDriver {
    public static RemoteWebDriver fromRemoteWebDriver(RemoteWebDriver remoteWebDriver) {
        ReusableRemoteWebDriver driver = new ReusableRemoteWebDriver(remoteWebDriver.getCommandExecutor(), remoteWebDriver.getCapabilities(), remoteWebDriver.getSessionId());
        try {
            ReusableRemoteWebDriver.checkReusability(remoteWebDriver.getSessionId(), driver);
            return driver;
        }
        catch (UnableReuseSessionException e) {
            throw new IllegalStateException("Reusing RemoteWebDriver session unexpectedly failed", e);
        }
    }

    public static RemoteWebDriver fromReusedSession(URL remoteAddress, Capabilities desiredCapabilities, SessionId sessionId) throws UnableReuseSessionException {
        ReusableRemoteWebDriver driver = new ReusableRemoteWebDriver(remoteAddress, desiredCapabilities, sessionId);
        ReusableRemoteWebDriver.checkReusability(sessionId, driver);
        return driver;
    }

    ReusableRemoteWebDriver() {
    }

    protected ReusableRemoteWebDriver(CommandExecutor executor, Capabilities capabilities, SessionId sessionId) {
        this.setCommandExecutor(executor);
        this.setReusedCapabilities(capabilities);
        this.setSessionId(sessionId.toString());
    }

    protected ReusableRemoteWebDriver(URL remoteAddress, Capabilities capabilities, SessionId sessionId) {
        HttpCommandExecutor httpCommandExecutor = new HttpCommandExecutor(remoteAddress);
        this.setCommandExecutor((CommandExecutor)httpCommandExecutor);
        this.setReusedCapabilities(capabilities);
        this.setValueToFieldInHttpCommandExecutor(httpCommandExecutor, "commandCodec", Dialect.OSS.getCommandCodec());
        this.setValueToFieldInHttpCommandExecutor(httpCommandExecutor, "responseCodec", Dialect.OSS.getResponseCodec());
        this.setSessionId(sessionId.toString());
    }

    private static void checkReusability(SessionId oldSessionId, RemoteWebDriver driver) throws UnableReuseSessionException {
        if (!oldSessionId.equals((Object)driver.getSessionId())) {
            throw new UnableReuseSessionException("The created session has another id then session we tried to reuse");
        }
        try {
            driver.getCurrentUrl();
        }
        catch (WebDriverException e) {
            throw new UnableReuseSessionException(e);
        }
    }

    void setReusedCapabilities(Capabilities capabilities) {
        Field capabilitiesField = ReusableRemoteWebDriver.getFieldSafely((Object)this, RemoteWebDriver.class, "capabilities");
        ReusableRemoteWebDriver.writeValueToField((Object)this, capabilitiesField, capabilities);
    }

    void setValueToFieldInHttpCommandExecutor(Object instance, String fieldName, Object value) {
        Field field = ReusableRemoteWebDriver.getFieldSafely(instance, HttpCommandExecutor.class, fieldName);
        ReusableRemoteWebDriver.writeValueToField(instance, field, value);
    }

    private static Field getFieldSafely(Object object, Class<?> clazz, String fieldName) {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static void writeValueToField(Object object, Field field, Object value) {
        boolean wasAccessible = field.isAccessible();
        if (!wasAccessible) {
            field.setAccessible(true);
        }
        try {
            field.set(object, value);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        if (!wasAccessible) {
            field.setAccessible(false);
        }
    }
}

