/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.drone.webdriver.utils;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;

public class Validate {
    private static final FileExecutableChecker fileExecutableChecker = new FileExecutableChecker();

    public static boolean empty(Object object) {
        return object == null;
    }

    public static boolean empty(String object) {
        return object == null || object.length() == 0;
    }

    public static boolean nonEmpty(String object) {
        return !Validate.empty(object);
    }

    public static void isEmpty(Object object, String message) throws IllegalArgumentException {
        if (Validate.empty(object)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isEmpty(String object, String message) throws IllegalArgumentException {
        if (Validate.empty(object)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isValidPath(String path, String message) throws IllegalArgumentException {
        Validate.isEmpty(path, message);
        File file = new File(path);
        if (!file.exists() || !file.canRead()) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isValidUrl(URL url, String message) throws IllegalArgumentException {
        if (url == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isValidUrl(String url, String message) throws IllegalArgumentException {
        Validate.isEmpty(url, message);
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(message, e);
        }
    }

    public static void isExecutable(String path, String message) throws IllegalArgumentException {
        if (!Validate.executable(path)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean executable(String path) {
        if (Validate.empty(path)) {
            return false;
        }
        File file = new File(path);
        if (!file.exists()) {
            throw new IllegalArgumentException(String.format("The file %s does not exist", path));
        }
        return fileExecutableChecker.canExecute(file);
    }

    private static final class FileExecutableChecker {
        private static final Logger log = Logger.getLogger(FileExecutableChecker.class.getName());
        private final Method isExecutableMethod;

        FileExecutableChecker() {
            Method m = null;
            try {
                m = File.class.getMethod("canExecute", new Class[0]);
            }
            catch (SecurityException e) {
                log.warning("Unable to verify executable bits for files, will consider them all executable. " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                log.warning("Unable to verify executable bits for files, will consider them all executable. " + e.getMessage());
            }
            this.isExecutableMethod = m;
        }

        public boolean canExecute(File file) {
            if (this.isExecutableMethod == null) {
                return true;
            }
            Boolean result = true;
            try {
                result = (Boolean)this.isExecutableMethod.invoke((Object)file, new Object[0]);
            }
            catch (IllegalArgumentException e) {
                log.warning("Unable to check if " + file.getAbsolutePath() + " can be executed, will consider it executable." + e.getMessage());
            }
            catch (IllegalAccessException e) {
                log.warning("Unable to check if " + file.getAbsolutePath() + " can be executed, will consider it executable." + e.getMessage());
            }
            catch (InvocationTargetException e) {
                log.warning("Unable to check if " + file.getAbsolutePath() + " can be executed, will consider it executable." + e.getMessage());
            }
            return result;
        }
    }
}

