/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.spring.integration.configuration;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.arquillian.spring.integration.configuration.SpringIntegrationConfiguration;

public class SpringIntegrationConfigurationExporter {
    public static final String SPRING_REMOTE_PROPERTIES = "arquillian-spring-remote-configuration.properties";

    public static String toString(SpringIntegrationConfiguration config) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Properties properties = new Properties();
            for (Map.Entry<String, String> property : config.getProperties().entrySet()) {
                SpringIntegrationConfigurationExporter.setPropertyValue(properties, property.getKey(), property.getValue());
            }
            properties.store(outputStream, "arquillian-spring-remote-configuration");
            return outputStream.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write the properties file.", e);
        }
    }

    public static SpringIntegrationConfiguration loadResource(InputStream inputStream) {
        try {
            Properties props = new Properties();
            props.load(inputStream);
            HashMap<String, String> properties = new HashMap<String, String>();
            Enumeration<?> propertyNames = props.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = (String)propertyNames.nextElement();
                properties.put(propertyName, SpringIntegrationConfigurationExporter.getPropertyValue(props, propertyName));
            }
            return new SpringIntegrationConfiguration(properties);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load the properties files.", e);
        }
    }

    private static String getPropertyValue(Properties properties, String propertyName) {
        String value = properties.getProperty(propertyName);
        if ("".equals(value)) {
            return null;
        }
        return value;
    }

    private static void setPropertyValue(Properties properties, String propertyName, String value) {
        properties.setProperty(propertyName, SpringIntegrationConfigurationExporter.getPropertyValueOrDefault(value));
    }

    private static String getPropertyValueOrDefault(String value) {
        return value != null ? value : "";
    }
}

