/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.jmx;

import java.io.IOException;
import java.net.InetAddress;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.management.remote.rmi.RMIServerImpl;
import org.jboss.arquillian.protocol.jmx.DefaultSocketFactory;

public class JMXConnectorServerExt {
    private static final Logger log = Logger.getLogger(JMXConnectorServerExt.class.getName());
    private JMXServiceURL serviceURL;
    private RMIConnectorServer connectorServer;
    private boolean shutdownRegistry;
    private Registry rmiRegistry;

    public JMXConnectorServerExt(JMXServiceURL serviceURL, int regPort) throws IOException {
        this.serviceURL = serviceURL;
        String host = serviceURL.getHost();
        this.rmiRegistry = LocateRegistry.getRegistry(host, regPort);
        try {
            this.rmiRegistry.list();
            log.fine("RMI registry running at host=" + host + ",port=" + regPort);
        }
        catch (Exception ex) {
            log.fine("No RMI registry running at host=" + host + ",port=" + regPort + ".  Will create one.");
            this.rmiRegistry = LocateRegistry.createRegistry(regPort, null, new DefaultSocketFactory(InetAddress.getByName(host)));
            this.shutdownRegistry = true;
        }
    }

    public void start(MBeanServer mbeanServer) throws IOException {
        String rmiHost = this.serviceURL.getHost();
        int rmiPort = this.serviceURL.getPort();
        DefaultSocketFactory serverSocketFactory = new DefaultSocketFactory(InetAddress.getByName(rmiHost));
        RMIJRMPServerImpl rmiServer = new RMIJRMPServerImpl(rmiPort, null, serverSocketFactory, null);
        this.connectorServer = new RMIConnectorServer(this.serviceURL, null, rmiServer, mbeanServer);
        log.fine("JMXConnectorServer created: " + this.serviceURL);
        this.connectorServer.start();
        this.rmiRegistry.rebind("jmxrmi", ((RMIServerImpl)rmiServer).toStub());
        log.fine("JMXConnectorServer started: " + this.serviceURL);
    }

    public void stop() {
        try {
            if (this.connectorServer != null) {
                this.connectorServer.stop();
                this.rmiRegistry.unbind("jmxrmi");
            }
            if (this.shutdownRegistry) {
                log.fine("Shutdown RMI registry");
                UnicastRemoteObject.unexportObject(this.rmiRegistry, true);
            }
            log.fine("JMXConnectorServer stopped");
        }
        catch (Exception ex) {
            log.log(Level.WARNING, "Cannot stop JMXConnectorServer", ex);
        }
    }
}

