/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.deployers;

import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;

@MessageLogger(projectCode="IJ")
public interface DeployersLogger
extends BasicLogger {
    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20001, value="Required license terms for %s")
    public void requiredLicenseTerms(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20002, value="Deployed: %s")
    public void deployed(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20003, value="Failure during validation report generation: %s")
    public void validationReportFailure(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20004, value="Only one connection definition found with a mismatch in class-name: %s")
    public void connectionDefinitionMismatch(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20005, value="Only one admin object found with a mismatch in class-name: %s")
    public void adminObjectMismatch(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=20006, value="ConnectionFactory is null")
    public void nullConnectionFactory();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=20007, value="Exception during createSubject(): %s")
    public void subjectCreationError(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20008, value="Invalid config-property: %s")
    public void invalidConfigProperty(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20009, value="Invalid connection definition with class-name: %s")
    public void connectionDefinitionInvalid(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=20010, value="Connection definition with missing class-name")
    public void connectionDefinitionNull();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=20011, value="Admin object with missing class-name")
    public void adminObjectNull();

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20012, value="Admin object not bound: %s")
    public void adminObjectNotBound(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20013, value="Connection factory not bound: %s")
    public void connectionFactoryNotBound(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20014, value="Admin object not specification compliant. See 13.4.2.3 for additional details: %s")
    public void adminObjectNotSpecCompliant(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20015, value="Connection factory not specification compliant. See 6.5.1.3 for additional details: %s")
    public void connectionFactoryNotSpecCompliant(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20016, value="Missing <recovery> element. XA recovery disabled for: %s")
    public void missingRecovery(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=20017, value="Invalid archive: %s")
    public void validationInvalidArchive(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20018, value="Enabling <validate-on-match> for %s")
    public void enablingValidateOnMatch(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=20019, value="Changed TransactionSupport for %s")
    public void changedTransactionSupport(String var1);
}

