/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.ModelValue;
import org.jboss.dmr.Property;

final class ListModelValue
extends ModelValue {
    public static final ModelNode[] NO_NODES = new ModelNode[0];
    private final List<ModelNode> list;

    ListModelValue() {
        super(ModelType.LIST);
        this.list = new ArrayList<ModelNode>();
    }

    private ListModelValue(ListModelValue orig) {
        super(ModelType.LIST);
        this.list = new ArrayList<ModelNode>(orig.list);
    }

    ListModelValue(List<ModelNode> list) {
        super(ModelType.LIST);
        this.list = list;
    }

    ListModelValue(DataInput in) throws IOException {
        super(ModelType.LIST);
        int count = in.readInt();
        ArrayList<ModelNode> list = new ArrayList<ModelNode>();
        for (int i = 0; i < count; ++i) {
            ModelNode value = new ModelNode();
            value.readExternal(in);
            list.add(value);
        }
        this.list = list;
    }

    @Override
    void writeExternal(DataOutput out) throws IOException {
        List<ModelNode> list = this.list;
        int size = list.size();
        out.writeInt(size);
        for (ModelNode node : list) {
            node.writeExternal(out);
        }
    }

    @Override
    ModelValue protect() {
        List<ModelNode> list = this.list;
        for (ModelNode node : list) {
            node.protect();
        }
        return list.getClass() == ArrayList.class ? new ListModelValue(Collections.unmodifiableList(list)) : this;
    }

    @Override
    long asLong() {
        return this.asInt();
    }

    @Override
    long asLong(long defVal) {
        return this.asInt();
    }

    @Override
    int asInt() {
        return this.list.size();
    }

    @Override
    int asInt(int defVal) {
        return this.asInt();
    }

    @Override
    boolean asBoolean() {
        return !this.list.isEmpty();
    }

    @Override
    boolean asBoolean(boolean defVal) {
        return this.asBoolean();
    }

    @Override
    Property asProperty() {
        if (this.list.size() == 2) {
            return new Property(this.list.get(0).asString(), this.list.get(1));
        }
        return super.asProperty();
    }

    @Override
    List<Property> asPropertyList() {
        ArrayList<Property> propertyList = new ArrayList<Property>();
        Iterator<ModelNode> i = this.list.iterator();
        while (i.hasNext()) {
            ModelNode node = i.next();
            if (node.getType() == ModelType.PROPERTY) {
                propertyList.add(node.asProperty());
                continue;
            }
            if (!i.hasNext()) continue;
            ModelNode value = i.next();
            propertyList.add(new Property(node.asString(), value));
        }
        return propertyList;
    }

    @Override
    ModelNode asObject() {
        ModelNode node = new ModelNode();
        Iterator<ModelNode> i = this.list.iterator();
        while (i.hasNext()) {
            ModelNode name = i.next();
            if (name.getType() == ModelType.PROPERTY) {
                Property property = name.asProperty();
                node.get(property.getName()).set(property.getValue());
                continue;
            }
            if (!i.hasNext()) continue;
            ModelNode value = i.next();
            node.get(name.asString()).set(value);
        }
        return node;
    }

    @Override
    ModelNode getChild(int index) {
        List<ModelNode> list = this.list;
        int size = list.size();
        if (size <= index) {
            for (int i = 0; i < index - size + 1; ++i) {
                list.add(new ModelNode());
            }
        }
        return list.get(index);
    }

    @Override
    ModelNode addChild() {
        ModelNode node = new ModelNode();
        this.list.add(node);
        return node;
    }

    @Override
    List<ModelNode> asList() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    ModelValue copy() {
        return new ListModelValue(this);
    }

    @Override
    ModelValue resolve() {
        ArrayList<ModelNode> copy = new ArrayList<ModelNode>(this.list.size());
        for (ModelNode node : this.list) {
            copy.add(node.resolve());
        }
        return new ListModelValue(copy);
    }

    @Override
    String asString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)stringWriter, true);
        this.format(writer, 0, false);
        return stringWriter.toString();
    }

    @Override
    void format(PrintWriter writer, int indent, boolean multiLineRequested) {
        boolean multiLine = multiLineRequested && this.list.size() > 1;
        List<ModelNode> list = this.asList();
        Iterator<ModelNode> iterator = list.iterator();
        writer.append('[');
        if (multiLine) {
            ListModelValue.indent(writer.append('\n'), indent + 1);
        }
        while (iterator.hasNext()) {
            ModelNode entry = iterator.next();
            entry.format(writer, multiLine ? indent + 1 : indent, multiLineRequested);
            if (!iterator.hasNext()) continue;
            if (multiLine) {
                ListModelValue.indent(writer.append(",\n"), indent + 1);
                continue;
            }
            writer.append(',');
        }
        if (multiLine) {
            ListModelValue.indent(writer.append('\n'), indent);
        }
        writer.append(']');
    }

    @Override
    void formatAsJSON(PrintWriter writer, int indent, boolean multiLineRequested) {
        boolean multiLine = multiLineRequested && this.list.size() > 1;
        List<ModelNode> list = this.asList();
        Iterator<ModelNode> iterator = list.iterator();
        writer.append('[');
        if (multiLine) {
            ListModelValue.indent(writer.append('\n'), indent + 1);
        }
        while (iterator.hasNext()) {
            ModelNode entry = iterator.next();
            entry.formatAsJSON(writer, multiLine ? indent + 1 : indent, multiLineRequested);
            if (!iterator.hasNext()) continue;
            if (multiLine) {
                ListModelValue.indent(writer.append(",\n"), indent + 1);
                continue;
            }
            writer.append(',');
        }
        if (multiLine) {
            ListModelValue.indent(writer.append('\n'), indent);
        }
        writer.append(']');
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof ListModelValue && this.equals((ListModelValue)other);
    }

    public boolean equals(ListModelValue other) {
        return this == other || other != null && ((Object)this.list).equals(other.list);
    }

    @Override
    public int hashCode() {
        return ((Object)this.list).hashCode();
    }

    @Override
    boolean has(int index) {
        return 0 <= index && index < this.list.size();
    }

    @Override
    ModelNode requireChild(int index) throws NoSuchElementException {
        try {
            return this.list.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            return super.requireChild(index);
        }
    }
}

