/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.dmr;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Stack;
import java.util.Vector;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelNodeParser;

public abstract class Parser {
    protected static final int OPEN_BRACE = 256;
    protected static final int CLOSE_BRACE = 257;
    protected static final int OPEN_BRACKET = 258;
    protected static final int CLOSE_BRACKET = 259;
    protected static final int OPEN_PAREN = 260;
    protected static final int CLOSE_PAREN = 261;
    protected static final int ARROW = 262;
    protected static final int COMMA = 263;
    protected static final int BIG = 264;
    protected static final int BYTES = 265;
    protected static final int INTEGER = 266;
    protected static final int DECIMAL = 267;
    protected static final int EXPRESSION = 268;
    protected static final int UNDEFINED = 269;
    protected static final int TRUE = 270;
    protected static final int FALSE = 271;
    protected static final int INT_VAL = 272;
    protected static final int INT_HEX_VAL = 273;
    protected static final int LONG_VAL = 274;
    protected static final int LONG_HEX_VAL = 275;
    protected static final int DOUBLE_SPECIAL_VAL = 276;
    protected static final int DEC_VAL = 277;
    protected static final int STR_VAL = 278;
    protected static final int TYPE_VAL = 279;
    protected static final int INITIAL = 0;
    private final LinkedList _yyLookaheadStack = new LinkedList();
    private final Vector _yyStateStack = new Vector(512, 512);
    private boolean _yyInError;
    private int _yyArgStart;
    private Object _yyValue;
    private InputStream _yyIs = System.in;
    private byte[] _yyBuffer;
    private int _yyBufferSize = 4096;
    private int _yyMatchStart;
    private int _yyBufferEnd;
    private int _yyBaseState;
    private int _yyTextStart;
    private int _yyLength;
    private Stack _yyLexerStack;
    private Stack _yyInputStack;
    private final ModelNodeParser m_this = (ModelNodeParser)this;

    public void setInput(InputStream is) {
        this._yyIs = is;
    }

    public InputStream getInput() {
        return this._yyIs;
    }

    public void yyPushInput(InputStream is) {
        int len = this._yyBufferEnd - this._yyMatchStart;
        byte[] leftOver = new byte[len];
        System.arraycopy(this._yyBuffer, this._yyMatchStart, leftOver, 0, len);
        Object[] states = new Object[4];
        states[0] = this._yyIs;
        states[1] = leftOver;
        if (this._yyInputStack == null) {
            this._yyInputStack = new Stack();
        }
        this._yyInputStack.push(states);
        this._yyIs = is;
        this._yyMatchStart = 0;
        this._yyBufferEnd = 0;
    }

    public void yyPopInput() {
        Object[] states = (Object[])this._yyInputStack.pop();
        this._yyIs = (InputStream)states[0];
        byte[] leftOver = (byte[])states[1];
        int curLen = this._yyBufferEnd - this._yyMatchStart;
        if (leftOver.length + curLen > this._yyBuffer.length) {
            byte[] newBuffer = new byte[leftOver.length + curLen];
            System.arraycopy(this._yyBuffer, this._yyMatchStart, newBuffer, 0, curLen);
            System.arraycopy(leftOver, 0, newBuffer, curLen, leftOver.length);
            this._yyBuffer = newBuffer;
            this._yyMatchStart = 0;
            this._yyBufferEnd = leftOver.length + curLen;
        } else {
            int end = this._yyBufferEnd;
            byte[] buffer = this._yyBuffer;
            int i = 0;
            for (int start = this._yyMatchStart; start < end; ++start) {
                buffer[i] = buffer[start];
                ++i;
            }
            System.arraycopy(leftOver, 0, buffer, curLen, leftOver.length);
            this._yyMatchStart = 0;
            this._yyBufferEnd = leftOver.length + curLen;
        }
    }

    public int yyInputStackSize() {
        return this._yyInputStack == null ? 0 : this._yyInputStack.size();
    }

    public String yyText() {
        if (this._yyMatchStart == this._yyTextStart) {
            return null;
        }
        return new String(this._yyBuffer, this._yyTextStart, this._yyMatchStart - this._yyTextStart);
    }

    public int yyLength() {
        return this._yyLength;
    }

    public void echo() {
        System.out.print(this.yyText());
    }

    protected void yyLess(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("yyLess function requires a non-zero value.");
        }
        if (n > this._yyMatchStart - this._yyTextStart) {
            throw new IndexOutOfBoundsException("yyLess function called with a too large index value " + n + ".");
        }
        this._yyMatchStart = this._yyTextStart + n;
    }

    protected void begin(int baseState) {
        this._yyBaseState = baseState;
    }

    protected void yyPushLexerState(int newState) {
        if (this._yyLexerStack == null) {
            this._yyLexerStack = new Stack();
        }
        this._yyLexerStack.push(new Integer(this._yyBaseState));
        this.begin(newState);
    }

    protected void yyPopLexerState() {
        this.begin((Integer)this._yyLexerStack.pop());
    }

    protected boolean yyRefreshBuffer() throws IOException {
        if (this._yyBuffer == null) {
            this._yyBuffer = new byte[this._yyBufferSize];
        }
        if (this._yyMatchStart > 0) {
            if (this._yyBufferEnd > this._yyMatchStart) {
                System.arraycopy(this._yyBuffer, this._yyMatchStart, this._yyBuffer, 0, this._yyBufferEnd - this._yyMatchStart);
                this._yyBufferEnd -= this._yyMatchStart;
                this._yyMatchStart = 0;
            } else {
                this._yyMatchStart = 0;
                this._yyBufferEnd = 0;
            }
        } else if (this._yyBufferEnd == this._yyBuffer.length) {
            byte[] newBuffer = new byte[this._yyBuffer.length + this._yyBuffer.length / 2];
            System.arraycopy(this._yyBuffer, 0, newBuffer, 0, this._yyBufferEnd);
            this._yyBuffer = newBuffer;
        }
        int readSize = this._yyIs.read(this._yyBuffer, this._yyBufferEnd, this._yyBuffer.length - this._yyBufferEnd);
        if (readSize > 0) {
            this._yyBufferEnd += readSize;
        } else if (readSize < 0 && !this.yyWrap()) {
            return this.yyRefreshBuffer();
        }
        return readSize >= 0;
    }

    public void yyResetBuffer() {
        this._yyMatchStart = 0;
        this._yyBufferEnd = 0;
    }

    public void setBufferSize(int bufferSize) {
        if (this._yyBufferEnd > this._yyMatchStart) {
            throw new IllegalArgumentException("Cannot change lexer buffer size at this moment.");
        }
        this._yyBufferSize = bufferSize;
        this._yyMatchStart = 0;
        this._yyBufferEnd = 0;
        if (this._yyBuffer != null && bufferSize != this._yyBuffer.length) {
            this._yyBuffer = new byte[bufferSize];
        }
    }

    protected int yyLex() throws IOException {
        char[] cc_ecs = cc_lexer.ecs;
        char[] cc_next = cc_lexer.next;
        char[] cc_check = cc_lexer.check;
        char[] cc_base = cc_lexer.base;
        char[] cc_default = cc_lexer.defaults;
        char[] cc_meta = cc_lexer.meta;
        char[] cc_accept = cc_lexer.accept;
        byte[] buffer = this._yyBuffer;
        block60: while (true) {
            int matchedLength;
            int cc_matchedState;
            block68: {
                cc_matchedState = this._yyBaseState;
                matchedLength = 0;
                int internalBufferEnd = this._yyBufferEnd;
                int lookahead = this._yyMatchStart;
                int cc_backupMatchedState = cc_matchedState;
                int cc_backupMatchedLength = 0;
                while (true) {
                    if (lookahead < internalBufferEnd) {
                        char symbol = cc_ecs[buffer[lookahead] & 0xFF];
                        int cc_toState = cc_matchedState;
                        while (cc_check[symbol + cc_base[cc_toState]] != cc_toState) {
                            if ((cc_toState = cc_default[cc_toState]) < 163) continue;
                            symbol = cc_meta[symbol];
                        }
                        if ((cc_toState = cc_next[symbol + cc_base[cc_toState]]) == 0) {
                            cc_matchedState = cc_backupMatchedState;
                            matchedLength = cc_backupMatchedLength;
                            break block68;
                        }
                        cc_matchedState = cc_toState;
                        ++lookahead;
                        ++matchedLength;
                        if (cc_accept[cc_matchedState] <= '\u0000') continue;
                        cc_backupMatchedState = cc_toState;
                        cc_backupMatchedLength = matchedLength;
                        continue;
                    }
                    int lookPos = lookahead - this._yyMatchStart;
                    boolean refresh = this.yyRefreshBuffer();
                    buffer = this._yyBuffer;
                    internalBufferEnd = this._yyBufferEnd;
                    lookahead = this._yyMatchStart + lookPos;
                    if (!refresh) break;
                }
                char symbol = cc_ecs[256];
                int cc_toState = cc_matchedState;
                while (cc_check[symbol + cc_base[cc_toState]] != cc_toState) {
                    if ((cc_toState = cc_default[cc_toState]) < 163) continue;
                    symbol = cc_meta[symbol];
                }
                if ((cc_toState = cc_next[symbol + cc_base[cc_toState]]) != 0) {
                    cc_matchedState = cc_toState;
                } else {
                    cc_matchedState = cc_backupMatchedState;
                    matchedLength = cc_backupMatchedLength;
                }
            }
            this._yyTextStart = this._yyMatchStart;
            this._yyMatchStart += matchedLength;
            this._yyLength = matchedLength;
            switch (cc_accept[cc_matchedState]) {
                case '\u0001': {
                    this._yyValue = this.m_this.parseToken();
                    return 256;
                }
                case '\u001f': {
                    continue block60;
                }
                case '\u0002': {
                    this._yyValue = this.m_this.parseToken();
                    return 257;
                }
                case ' ': {
                    continue block60;
                }
                case '\u0003': {
                    this._yyValue = this.m_this.parseToken();
                    return 258;
                }
                case '!': {
                    continue block60;
                }
                case '\u0004': {
                    this._yyValue = this.m_this.parseToken();
                    return 259;
                }
                case '\"': {
                    continue block60;
                }
                case '\u0005': {
                    this._yyValue = this.m_this.parseToken();
                    return 260;
                }
                case '#': {
                    continue block60;
                }
                case '\u0006': {
                    this._yyValue = this.m_this.parseToken();
                    return 261;
                }
                case '$': {
                    continue block60;
                }
                case '\u0007': {
                    this._yyValue = this.m_this.parseToken();
                    return 263;
                }
                case '%': {
                    continue block60;
                }
                case '\b': {
                    this._yyValue = this.m_this.parseToken();
                    return 262;
                }
                case '&': {
                    continue block60;
                }
                case '\t': {
                    this._yyValue = this.m_this.parseToken();
                    return 270;
                }
                case '\'': {
                    continue block60;
                }
                case '\n': {
                    this._yyValue = this.m_this.parseToken();
                    return 271;
                }
                case '(': {
                    continue block60;
                }
                case '\u000b': {
                    this._yyValue = this.m_this.parseToken();
                    return 264;
                }
                case ')': {
                    continue block60;
                }
                case '\f': {
                    this._yyValue = this.m_this.parseToken();
                    return 265;
                }
                case '*': {
                    continue block60;
                }
                case '\r': {
                    this._yyValue = this.m_this.parseToken();
                    return 267;
                }
                case '+': {
                    continue block60;
                }
                case '\u000e': {
                    this._yyValue = this.m_this.parseToken();
                    return 266;
                }
                case ',': {
                    continue block60;
                }
                case '\u000f': {
                    this._yyValue = this.m_this.parseToken();
                    return 268;
                }
                case '-': {
                    continue block60;
                }
                case '\u0010': {
                    this._yyValue = this.m_this.parseToken();
                    return 269;
                }
                case '.': {
                    continue block60;
                }
                case '\u0011': {
                    this._yyValue = this.m_this.parsePlainValue();
                    return 274;
                }
                case '/': {
                    continue block60;
                }
                case '\u0012': {
                    this._yyValue = this.m_this.parsePlainValue();
                    return 275;
                }
                case '0': {
                    continue block60;
                }
                case '\u0013': {
                    this._yyValue = this.m_this.parsePlainValue();
                    return 272;
                }
                case '1': {
                    continue block60;
                }
                case '\u0014': {
                    this._yyValue = this.m_this.parsePlainValue();
                    return 273;
                }
                case '2': {
                    continue block60;
                }
                case '\u0015': {
                    this._yyValue = this.m_this.parsePlainValue();
                    return 276;
                }
                case '3': {
                    continue block60;
                }
                case '\u0016': {
                    this._yyValue = this.m_this.parsePlainValue();
                    return 277;
                }
                case '4': {
                    continue block60;
                }
                case '\u0017': {
                    this._yyValue = this.m_this.parsePlainValue();
                    return 279;
                }
                case '5': {
                    continue block60;
                }
                case '\u0018': {
                    this._yyValue = this.m_this.parseStringValue();
                    return 278;
                }
                case '6': {
                    continue block60;
                }
                case '\u0019': {
                    this.m_this.ignored();
                }
                case '7': {
                    continue block60;
                }
                case '\u001a': {
                    this.m_this.invalid();
                }
                case '8': {
                    continue block60;
                }
                case '\u001b': {
                    this.m_this.parseEOF();
                    return 0;
                }
                case '9': {
                    continue block60;
                }
                case '\u001c': {
                    this.echo();
                }
                case ':': {
                    continue block60;
                }
                case '\u001d': {
                    return 0;
                }
                case ';': {
                    continue block60;
                }
            }
            break;
        }
        throw new IOException("Internal error in Parser lexer.");
    }

    public int yyParse() throws IOException {
        char[] cc_ecs = cc_parser.ecs;
        char[] cc_next = cc_parser.next;
        char[] cc_check = cc_parser.check;
        char[] cc_base = cc_parser.base;
        char[] cc_default = cc_parser.defaults;
        char[] cc_gotoDefault = cc_parser.gotoDefault;
        char[] cc_rule = cc_parser.rule;
        char[] cc_lhs = cc_parser.lhs;
        LinkedList cc_lookaheadStack = this._yyLookaheadStack;
        Vector cc_stateStack = this._yyStateStack;
        if (cc_stateStack.size() == 0) {
            cc_stateStack.add(new YYParserState());
        }
        int cc_toState = 0;
        while (true) {
            YYParserState cc_lookahead;
            if (cc_lookaheadStack.size() == 0) {
                this._yyValue = null;
                int val = this.yyLex();
                cc_lookahead = new YYParserState(val, this._yyValue);
                cc_lookaheadStack.add(cc_lookahead);
            } else {
                cc_lookahead = (YYParserState)cc_lookaheadStack.getLast();
            }
            char cc_ch = cc_ecs[cc_lookahead.token];
            int cc_fromState = ((YYParserState)cc_stateStack.get((int)(cc_stateStack.size() - 1))).state;
            char cc_symbol = cc_ch;
            cc_toState = cc_fromState;
            while (cc_check[cc_symbol + cc_base[cc_toState]] != cc_toState) {
                if ((cc_toState = cc_default[cc_toState]) < 57) continue;
                cc_symbol = '\u0000';
            }
            if ((cc_toState = (int)((short)cc_next[cc_symbol + cc_base[cc_toState]])) > 0) {
                cc_lookahead.state = cc_toState;
                cc_stateStack.add(cc_lookahead);
                cc_lookaheadStack.removeLast();
                continue;
            }
            if (cc_toState == 0) {
                if (this._yyInError) {
                    if (cc_ch == '\u0001') {
                        if (this._yyStateStack.size() > 1) {
                            this._yyStateStack.setSize(this._yyStateStack.size() - 1);
                            continue;
                        }
                        return 1;
                    }
                    if (cc_ch == '\u0000') {
                        return 1;
                    }
                    cc_lookaheadStack.removeLast();
                    continue;
                }
                if (this.yyParseError(cc_lookahead.token)) {
                    return 1;
                }
                this._yyLookaheadStack.add(new YYParserState(1, this._yyValue));
                this._yyInError = true;
                continue;
            }
            this._yyInError = false;
            int cc_ruleState = -cc_toState;
            this._yyArgStart = cc_stateStack.size() - cc_rule[cc_ruleState] - 1;
            cc_fromState = ((YYParserState)cc_stateStack.get((int)this._yyArgStart)).state;
            if (cc_ruleState == 1) {
                cc_toState = 0;
            } else {
                cc_toState = cc_fromState + 58;
                int cc_tmpCh = cc_lhs[cc_ruleState] - 25;
                while (cc_check[cc_tmpCh + cc_base[cc_toState]] != cc_toState) {
                    cc_toState = cc_gotoDefault[cc_toState - 58];
                }
                cc_toState = cc_next[cc_tmpCh + cc_base[cc_toState]];
            }
            this._yyValue = null;
            switch (cc_ruleState) {
                case 1: {
                    return 0;
                }
                case 2: {
                    return this.m_this.parse((ModelNode)this.yyGetValue(1));
                }
                case 37: {
                    break;
                }
                case 3: {
                    this._yyValue = this.m_this.parseBigDecimal((String)this.yyGetValue(3));
                }
                case 38: {
                    break;
                }
                case 4: {
                    this._yyValue = this.m_this.parseBigDecimal((String)this.yyGetValue(3));
                }
                case 39: {
                    break;
                }
                case 5: {
                    this._yyValue = this.m_this.parseBigInteger((String)this.yyGetValue(3));
                }
                case 40: {
                    break;
                }
                case 6: {
                    this._yyValue = this.m_this.parseBoolean();
                }
                case 41: {
                    break;
                }
                case 7: {
                    this._yyValue = this.m_this.parseBoolean();
                }
                case 42: {
                    break;
                }
                case 8: {
                    this._yyValue = this.m_this.finishBytes((ByteArrayOutputStream)this.yyGetValue(1));
                }
                case 43: {
                    break;
                }
                case 9: {
                    this._yyValue = this.m_this.finishBytes((ByteArrayOutputStream)this.yyGetValue(1));
                }
                case 44: {
                    break;
                }
                case 10: {
                    this._yyValue = this.m_this.emptyBytes();
                }
                case 45: {
                    break;
                }
                case 11: {
                    this._yyValue = this.m_this.parseDouble((String)this.yyGetValue(1));
                }
                case 46: {
                    break;
                }
                case 12: {
                    this._yyValue = this.m_this.parseExpression((String)this.yyGetValue(2));
                }
                case 47: {
                    break;
                }
                case 13: {
                    this._yyValue = this.m_this.parseInt((String)this.yyGetValue(1));
                }
                case 48: {
                    break;
                }
                case 14: {
                    this._yyValue = this.m_this.parseIntHex((String)this.yyGetValue(1));
                }
                case 49: {
                    break;
                }
                case 15: {
                    this._yyValue = this.m_this.parseLong((String)this.yyGetValue(1));
                }
                case 50: {
                    break;
                }
                case 16: {
                    this._yyValue = this.m_this.parseLongHex((String)this.yyGetValue(1));
                }
                case 51: {
                    break;
                }
                case 17: {
                    this._yyValue = this.m_this.parseEmptyList();
                }
                case 52: {
                    break;
                }
                case 18: {
                    this._yyValue = this.m_this.finishList((ModelNode)this.yyGetValue(1));
                }
                case 53: {
                    break;
                }
                case 19: {
                    this._yyValue = this.m_this.finishList((ModelNode)this.yyGetValue(1));
                }
                case 54: {
                    break;
                }
                case 20: {
                    this._yyValue = this.m_this.parseEmptyObject();
                }
                case 55: {
                    break;
                }
                case 21: {
                    this._yyValue = this.m_this.finishObject((ModelNode)this.yyGetValue(1));
                }
                case 56: {
                    break;
                }
                case 22: {
                    this._yyValue = this.m_this.finishObject((ModelNode)this.yyGetValue(1));
                }
                case 57: {
                    break;
                }
                case 23: {
                    this._yyValue = this.m_this.parseProperty((String)this.yyGetValue(2), (ModelNode)this.yyGetValue(4));
                }
                case 58: {
                    break;
                }
                case 24: {
                    this._yyValue = this.m_this.parseString((String)this.yyGetValue(1));
                }
                case 59: {
                    break;
                }
                case 25: {
                    this._yyValue = this.m_this.parseType((String)this.yyGetValue(1));
                }
                case 60: {
                    break;
                }
                case 26: {
                    this._yyValue = this.m_this.parseUndefined();
                }
                case 61: {
                    break;
                }
                case 27: {
                    this._yyValue = this.m_this.startBytesInt((String)this.yyGetValue(3));
                }
                case 62: {
                    break;
                }
                case 28: {
                    this._yyValue = this.m_this.startBytesHex((String)this.yyGetValue(3));
                }
                case 63: {
                    break;
                }
                case 29: {
                    this._yyValue = this.m_this.nextByteInt((ByteArrayOutputStream)this.yyGetValue(1), (String)this.yyGetValue(3));
                }
                case 64: {
                    break;
                }
                case 30: {
                    this._yyValue = this.m_this.nextByteHex((ByteArrayOutputStream)this.yyGetValue(1), (String)this.yyGetValue(3));
                }
                case 65: {
                    break;
                }
                case 31: {
                    this._yyValue = this.m_this.parseStartList((ModelNode)this.yyGetValue(2));
                }
                case 66: {
                    break;
                }
                case 32: {
                    this._yyValue = this.m_this.parseListItem((ModelNode)this.yyGetValue(1), (ModelNode)this.yyGetValue(3));
                }
                case 67: {
                    break;
                }
                case 33: {
                    this._yyValue = this.m_this.parseStartObject((String)this.yyGetValue(2), (ModelNode)this.yyGetValue(4));
                }
                case 68: {
                    break;
                }
                case 34: {
                    this._yyValue = this.m_this.parseObjectItem((ModelNode)this.yyGetValue(1), (String)this.yyGetValue(3), (ModelNode)this.yyGetValue(5));
                }
                case 69: {
                    break;
                }
                default: {
                    throw new IOException("Internal error in Parser parser.");
                }
            }
            YYParserState cc_reduced = new YYParserState(-cc_ruleState, this._yyValue, cc_toState);
            this._yyValue = null;
            cc_stateStack.setSize(this._yyArgStart + 1);
            cc_stateStack.add(cc_reduced);
        }
    }

    protected YYParserState yyPeekLookahead() {
        return (YYParserState)this._yyLookaheadStack.getLast();
    }

    protected void yyPopLookahead() {
        this._yyLookaheadStack.removeLast();
    }

    protected void yyClearError() {
        this._yyInError = false;
    }

    protected boolean yyParseError(int terminal) throws IOException {
        return false;
    }

    protected Object yyGetValue(int arg) {
        return ((YYParserState)this._yyStateStack.get((int)(this._yyArgStart + arg))).value;
    }

    protected void yySetValue(Object value) {
        this._yyValue = value;
    }

    protected void begin(String state) {
        if ("INITIAL".equals(state)) {
            this.begin(0);
            return;
        }
        throw new IllegalArgumentException("Unknown lexer state: " + state);
    }

    protected void yyPushLexerState(String state) {
        if ("INITIAL".equals(state)) {
            this.yyPushLexerState(0);
            return;
        }
        throw new IllegalArgumentException("Unknown lexer state: " + state);
    }

    protected boolean yyWrap() throws IOException {
        return true;
    }

    private static final class YYParserState {
        int token;
        Object value;
        int state;

        YYParserState() {
            this(0, null, 0);
        }

        YYParserState(int token) {
            this(token, null, 0);
        }

        YYParserState(int token, Object value) {
            this(token, value, 0);
        }

        YYParserState(int token, Object value, int state) {
            this.token = token;
            this.value = value;
            this.state = state;
        }
    }

    private static final class cc_parser {
        private static char[] rule = "\u0000\u0001\u0001\u0003\u0003\u0003\u0001\u0001\u0002\u0003\u0003\u0001\u0002\u0001\u0001\u0001\u0001\u0002\u0002\u0003\u0002\u0002\u0003\u0005\u0001\u0001\u0001\u0003\u0003\u0003\u0003\u0002\u0003\u0004\u0005".toCharArray();
        private static char[] ecs = "\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0000\u0016\u0017\u0018".toCharArray();
        private static char[] base = "\u00190\u000f\u0001\u0003\u0000\u0007\u00d4IJTU_`jku\n\u0000\u0005\u00d5\bv\u001a\u0080\u00040\u00ca\u000f\u0000\u0081\u008b\u0003\u008c7\u0096\u0002\u0000\u0000\u0097\u00a1\u00a2\u00ac\u001d4\u00ad\u00b4\u00b5\u00bc0\u00c4C\u00b7\u00d8\u0000\u00cc\u00bf\u00e2\u00f0\u00fc\u00f5\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00f6\u00fc\u00fc\u00f7\u00f8\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00fc\u00f9\u00fc\u00fc\u00fc".toCharArray();
        private static char[] next = "\ufffe\u0000\u001d*\u00002-\u0000\u001f\uffe1\uffff#\u0000\uffe1 \u001b\u001c$+,\u0018./\u0000\u001a3\u0000\u0001\u0000\u0002\u001e\u0003\uffe5(%\u0004\u0005)\uffe5\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0000\u0016\u0000\uffe0\u0000\uffe4&\uffe0\u0000\u00000\uffe4\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0017\u0000\ufffa\ufff96\ufffa\ufff9\ufffa\ufff9\ufffa\ufff9\ufffa\ufff9\ufff3\ufff2\u0000\ufff3\ufff2\ufff3\ufff2\ufff3\ufff2\ufff3\ufff2\ufff1\ufff0\u0000\ufff1\ufff0\ufff1\ufff0\ufff1\ufff0\ufff1\ufff0\ufff5\uffe8\u0000\ufff5\uffe8\ufff5\uffe8\ufff5\uffe8\ufff5\uffe8\uffe7\uffec\u0000\uffe7\uffec\uffe7\uffec\uffe7\uffec\uffe7\uffec\uffef\ufff4\u0000\uffef\ufff4\uffef\ufff4\uffef\ufff4\uffef\ufff4\ufff8\uffee\u0000\ufff8\uffee\ufff8\uffee\ufff8\uffee\ufff8\uffee\uffeb\ufffb\u0000\uffeb\ufffb\uffeb\ufffb\uffeb\ufffb\uffeb\ufffb\ufffc\ufffd\u0000\ufffc\ufffd\ufffc\ufffd\ufffc\ufffd\ufffc\ufffd\ufff6\ufff7\u0000\ufff6\ufff7\ufff6\ufff7\ufff6\ufff7\ufff6\ufff7\uffe3\uffe2\u0000\uffdf\u0000\uffed\uffe3\uffe2\uffed\uffdf\uffed\uffde\uffed\uffea\uffed\u0000\uffea\uffde\uffea\u0000\uffea\uffe9\uffea\u0000\uffe9\u0000\uffe9\u0000\uffe9\uffe6\uffe9\u0000\uffe6\u0000\uffe6!\uffe6'\uffe6\"7\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0011\u0012\u0013\u0014\u0015\u0000\u00191458\u0000\u0000\u0000\u0000\u0000\u0000".toCharArray();
        private static char[] check = "\u00129\u0005\u001d\u0003$ \u0013\u0013\u0019\u0011\u0015\u0011\u0019\u0013\u0004\u0004\u0015\u001d\u001d\u0002  \u0005\u0003$\u0004\u0000\u0017\u0000\u0006\u0000+\u001c\u0017\u0000\u0000\u001c+\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0001\u00011\u0001,\u001a1\u0001\u0001\",\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\b\t3\b\t\b\t\b\t\b\t\n\u000b9\n\u000b\n\u000b\n\u000b\n\u000b\f\r9\f\r\f\r\f\r\f\r\u000e\u000f9\u000e\u000f\u000e\u000f\u000e\u000f\u000e\u000f\u0010\u00169\u0010\u0016\u0010\u0016\u0010\u0016\u0010\u0016\u0018\u001e9\u0018\u001e\u0018\u001e\u0018\u001e\u0018\u001e\u001f!9\u001f!\u001f!\u001f!\u001f!#'9#'#'#'#'()9()()()()*-9*-*-*-*-./9490./040802092829272979797\u00077\u0007\u0007\u0014\u0007\u0014\u0007\u001b\u0007\u001455\u001b999999999999999:::::<<\\_`pssssss".toCharArray();
        private static char[] defaults = "9\u0000\u0000\u0001\u0003\u0003\u0003\u0005\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0007\u0005\u0011\u0005\u0013\u0013\u0007\u0005\u0007\u0014\u0017\u0003\u001b\u001b\u0007\u0007\u001b\u0007\u0000\u0007\u0001\u0000\u0000\u0007\u0007\u0007\u0007\u0013\u0013\u0007\u0013\u0013\u0007\u0014\u0007\u0017\u0013\u0017\u0000\u0007\u00139".toCharArray();
        private static char[] gotoDefault = "ss:sssssssssssssssssssssssssssssss<ss<<sssssssssssssss<sss".toCharArray();
        private static char[] lhs = "\u0000\u0019\u001a\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001b\u001c\u001c\u001c\u001c\u001d\u001d\u001e\u001e".toCharArray();

        private cc_parser() {
        }
    }

    private static final class cc_lexer {
        private static char[] accept = "\u0000\u001a\u0019\u001a\u0005\u0006\u0007\u001a\u0013\u0013\u001a\u001a\u001a\u001a\u001a\u001a\u001a\u001a\u001a\u001a\u001a\u001a\u0003\u0004\u001a\u001a\u001a\u001a\u001a\u001a\u001a\u0001\u0002\u001b\u0000\u0018\u0000\u0000\u0000\u0000\u0011\u0000\b\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0016\u0014\u0000\u0000\u0000\u0000\u0000\u0017\u0000\u0000\u0000\u0015\u0000\u0000\u0000\u0000\u0000\u000b\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0012\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\t\u0000\u0000\u0016\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\f\u0000\u0000\n\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\r\u0000\u000e\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0010\u0000\u0000\u000f".toCharArray();
        private static char[] ecs = "\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0002\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0003\u0000\u0000\u0000\u0000\u0000\u0004\u0005\u0000\u0000\u0006\u0007\b\u0000\t\n\n\n\n\n\n\n\n\n\u0000\u0000\u0000\u000b\f\u0000\u0000\r\u000e\u000f\u0010\u0011\u0012\u0013\u0000\u0014\u0015\u0000\u0016\u0017\u0018\u0019\u001a\u0000\u001b\u001c\u001d\u001e\u0000\u0000\u001f \u0000!\"#\u0000$\u0000%&'()*+\u0000,\u0000\u0000-./01\u00002345\u0000\u000067\u00008\u00009\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000:".toCharArray();
        private static char[] base = "N\u0000\u0000\u0000\u0000\u0000\u0000\u0003\u0000\u0001\u0002\u0000\u0003\u0000\u0000\u0001\u0000\u0001\u0003\u0006\u0006\u000f\u0000\u0000\u0002\u0001\u0002\u0003\u000b\t\r\u0000\u0000\u0000\u0000\u0000\u0002\u000e\u00005\u0000#\u0000\u0018'$$)'\u001b*/qurqs~d\\jaf``n\u0000\u0081t\u0083\u0089\u008d\u0081\u0000q\u0000\u008b\u0000\u008e\u0086\u008d\u0091\u0092\u0000{ytt\u007f\u0080\u0081\t\u0000\r\u009a\u0090\u0097\u009d\u0080\u00a1\u00a0\u009a\u00a1\u0081\u0087\u008d\u008e\u008d\u0000\u008f\u0000\u0000\u00a9\u00a3\u00af\u0000\u00a1\u0092\u0000\u00a4\u0000\u00ac\u0000\u009c\u008f\u0000\u009a\u0098\u00b6\u00a9\u00af\u00ac\u0095\u00ad\u00b3\u009f\u009a\u009c\u00a0\u00bc\u00c0\u00be\u009c\u00b4\u00c4\u0000\u00aa\u0000\u00ae\u00c1\u00c6\u00c1\u00cb\u00ac\u00b5\u00d1\u00ce\u0000\u00b1\u0000\u00cb\u00c7\u0000\u0000\u00e3".toCharArray();
        private static char[] next = "\"\u0002\u0002#\u0000\"\u0000\u0000'\t\t\u0000\b\t*5n[oo+2(%0,3&.p6/-q$7\"489>[<DCC:1CCCCCC)\u0000=;?@A1BBEFGHIJKLCCCCCC\u0001\u0002\u0002\u0003\u0004\u0005\u0006\u0007\u0001\b\t\n\u0001\u0001\u000b\u0001\f\r\u0001\u0001\u000e\u0001\u000f\u0001\u0010\u0011\u0012\u0001\u0013\u0014\u0015\u0001\u0001\u0016\u0001\u0017\u0001\u0001\u0018\u0001\u0019\u001a\u001b\u0001\u001c\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u001d\u001e\u0001\u0001\u001f !MNOPQRSTUVWXYZ\\]^_`abIcdeIfghijklmrIstuvwxyz{|}~\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008cI\u008d\u008e\u008f\u0090\u0091\u0092\u0093\u0094\u0095\u0096\u0097MI\u0098\u0099\u009a\u009b\u009c\u009dI\u009e\u009f\u00a0\u00a1\u00a2II\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000".toCharArray();
        private static char[] check = "\u00a3\u0002\u0002\u0003$$\u00a4n\b\b\b\u00a4\u0007\u0007\n\u0011[B[[\u000b\u000f\b\u0007\u000e\u000b\u000f\u0007\f]\u0012\r\u000b]\u0003\u0013$\u0010\u0014\u0015\u001bB\u0019+))\u0018\u000e))))))\b\t\u001a\u0018\u001c\u001d\u001e%'',-./0123))))))\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000456789:;<=>?@ACDEFGHJLNOPQRTUVWXYZ^_`abcdefghijkmpqrtuwy{|~\u007f\u0080\u0081\u0082\u0083\u0084\u0085\u0086\u0087\u0088\u0089\u008a\u008b\u008c\u008d\u008e\u008f\u0090\u0092\u0094\u0095\u0096\u0097\u0098\u0099\u009a\u009b\u009c\u009e\u00a0\u00a1\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4\u00a4".toCharArray();
        private static char[] defaults = "\u00a4\u00a4\u0001\u00a3\u00a4\u00a4\u00a4\u0001\u0001\b\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u00a4\u00a4\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u00a4\u00a4\u00a4\u0003\u00a4\u0003\u0001\u0010\u0001\u00a4\u0001\u00a4\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001')\u0001\u0001\u0001\u0001\u0001\u00a4\u00010\u0001\u00a4\u0001\u0001\u0001\u0001\u0001\u00a4\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u00a4\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u00a4\u0001[n\u0001\u0001\u0001Q\u0001\u00010\u0001L\u0001\u00a4\u0001\u0001\u00a4\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u00a4\u0001\u00a4\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0001\u0082\u0001\u00a4\u0001\u0001\u00a4\u00a4\u00a4".toCharArray();
        private static char[] meta = "\u0000\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0001".toCharArray();

        private cc_lexer() {
        }
    }
}

