/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq;

import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.logging.Logger;
import org.jboss.mq.JBossMQXid;
import org.jboss.mq.SpySession;
import org.jboss.mq.SpyXAException;

public class SpyXAResource
implements XAResource {
    private static final Logger log = Logger.getLogger(SpyXAResource.class);
    private static boolean trace = log.isTraceEnabled();
    SpySession session;

    SpyXAResource(SpySession session) {
        trace = log.isTraceEnabled();
        this.session = session;
        if (trace) {
            log.trace((Object)("Created " + this));
        }
    }

    public boolean setTransactionTimeout(int arg1) throws XAException {
        return false;
    }

    public int getTransactionTimeout() throws XAException {
        return 0;
    }

    public boolean isSameRM(XAResource arg1) throws XAException {
        if (!(arg1 instanceof SpyXAResource)) {
            return false;
        }
        return ((SpyXAResource)arg1).session.connection.spyXAResourceManager == this.session.connection.spyXAResourceManager;
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (trace) {
            log.trace((Object)("Commit xid=" + xid + ", onePhase=" + onePhase + " " + this));
        }
        xid = this.convertXid(xid);
        try {
            this.session.connection.spyXAResourceManager.commit(xid, onePhase);
        }
        catch (Throwable t) {
            throw SpyXAException.getAsXAException("Resource manager error during commit", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(Xid xid, int flags) throws XAException {
        if (trace) {
            log.trace((Object)("End xid=" + xid + ", flags=" + flags + " " + this));
        }
        xid = this.convertXid(xid);
        Object object = this.session.runLock;
        synchronized (object) {
            switch (flags) {
                case 0x2000000: {
                    this.session.unsetCurrentTransactionId(xid);
                    this.session.connection.spyXAResourceManager.suspendTx(xid);
                    break;
                }
                case 0x20000000: {
                    this.session.unsetCurrentTransactionId(xid);
                    this.session.connection.spyXAResourceManager.endTx(xid, false);
                    break;
                }
                case 0x4000000: {
                    this.session.unsetCurrentTransactionId(xid);
                    this.session.connection.spyXAResourceManager.endTx(xid, true);
                }
            }
        }
    }

    public void forget(Xid xid) throws XAException {
        if (trace) {
            log.trace((Object)("Forget xid=" + xid + " " + this));
        }
        xid = this.convertXid(xid);
        try {
            this.session.connection.spyXAResourceManager.forget(xid);
        }
        catch (Throwable t) {
            throw SpyXAException.getAsXAException("Resource manager error during forget", t);
        }
    }

    public int prepare(Xid xid) throws XAException {
        if (trace) {
            log.trace((Object)("Prepare xid=" + xid + " " + this));
        }
        xid = this.convertXid(xid);
        try {
            return this.session.connection.spyXAResourceManager.prepare(xid);
        }
        catch (Throwable t) {
            throw SpyXAException.getAsXAException("Resource manager error during prepare", t);
        }
    }

    public Xid[] recover(int arg1) throws XAException {
        if (trace) {
            log.trace((Object)("Recover arg1=" + arg1 + " " + this));
        }
        try {
            return this.session.connection.spyXAResourceManager.recover(arg1);
        }
        catch (Throwable t) {
            throw SpyXAException.getAsXAException("Resource manager error during recover", t);
        }
    }

    public void rollback(Xid xid) throws XAException {
        if (trace) {
            log.trace((Object)("Rollback xid=" + xid + " " + this));
        }
        xid = this.convertXid(xid);
        try {
            this.session.connection.spyXAResourceManager.rollback(xid);
        }
        catch (Throwable t) {
            throw SpyXAException.getAsXAException("Resource manager error during rollback", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(Xid xid, int flags) throws XAException {
        if (trace) {
            log.trace((Object)("Start xid=" + xid + ", flags=" + flags + " " + this));
        }
        xid = this.convertXid(xid);
        boolean convertTx = false;
        if (this.session.getCurrentTransactionId() != null) {
            if (flags == 0 && this.session.getCurrentTransactionId() instanceof Long) {
                convertTx = true;
            } else {
                XAException e = new XAException("Attempt to enlist in " + xid + " with TMNOFLAGS when already enlisted " + this.session.getCurrentTransactionId());
                e.errorCode = -9;
                throw e;
            }
        }
        Object object = this.session.runLock;
        synchronized (object) {
            switch (flags) {
                case 0: {
                    if (convertTx) {
                        this.session.setCurrentTransactionId(this.session.connection.spyXAResourceManager.convertTx((Long)this.session.getCurrentTransactionId(), xid));
                        break;
                    }
                    this.session.setCurrentTransactionId(this.session.connection.spyXAResourceManager.startTx(xid));
                    break;
                }
                case 0x200000: {
                    this.session.setCurrentTransactionId(this.session.connection.spyXAResourceManager.joinTx(xid));
                    break;
                }
                case 0x8000000: {
                    this.session.setCurrentTransactionId(this.session.connection.spyXAResourceManager.resumeTx(xid));
                }
            }
            this.session.runLock.notify();
        }
    }

    public String toString() {
        return "SpyXAResource[session=" + this.session + ']';
    }

    protected Xid convertXid(Xid xid) throws XAException {
        if (xid == null) {
            XAException e = new XAException("Null xid");
            e.errorCode = -4;
            throw e;
        }
        if (xid instanceof JBossMQXid) {
            return xid;
        }
        return new JBossMQXid(xid);
    }
}

