/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.il.http;

import java.util.Properties;
import javax.jms.JMSException;
import org.jboss.logging.Logger;
import org.jboss.mq.il.ServerIL;
import org.jboss.mq.il.ServerILFactory;
import org.jboss.mq.il.http.HTTPClientILService;
import org.jboss.mq.il.http.HTTPServerIL;

public class HTTPServerILFactory
implements ServerILFactory {
    public static final String SERVER_IL_FACTORY = HTTPServerILFactory.class.getName();
    public static final String CLIENT_IL_SERVICE = HTTPClientILService.class.getName();
    public static final String SERVER_URL_KEY = "org.jboss.mq.il.http.url";
    public static final String TIMEOUT_KEY = "org.jboss.mq.il.http.timeout";
    public static final String REST_INTERVAL_KEY = "org.jboss.mq.il.http.restinterval";
    private static Logger log = Logger.getLogger(HTTPServerILFactory.class);
    private HTTPServerIL serverIL;

    public HTTPServerILFactory() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"created");
        }
    }

    public ServerIL getServerIL() throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"getServerIL()");
        }
        return this.serverIL;
    }

    public void init(Properties props) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)("init(Properties " + props.toString() + ")"));
        }
        if (!props.containsKey(SERVER_URL_KEY)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The supplied properties don't include a server URL entry.  Now checking to see if it is specified in the system properties.");
            }
            if (System.getProperties().containsKey(SERVER_URL_KEY)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The server URL property was found in the system properties.  Will use it.");
                }
                props.setProperty(SERVER_URL_KEY, System.getProperty(SERVER_URL_KEY));
            } else {
                throw new JMSException("A required connection property was not set: org.jboss.mq.il.http.url");
            }
        }
        this.serverIL = new HTTPServerIL(props.getProperty(SERVER_URL_KEY));
    }
}

