/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mq.server.jmx;

import java.util.StringTokenizer;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.mq.MessageStatistics;
import org.jboss.mq.SpyDestination;
import org.jboss.mq.server.BasicQueueParameters;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.MessageCounter;
import org.jboss.mq.server.Receivers;
import org.jboss.mq.server.jmx.DestinationMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.util.naming.Util;
import org.w3c.dom.Element;

public abstract class DestinationMBeanSupport
extends ServiceMBeanSupport
implements DestinationMBean,
MBeanRegistration {
    protected SpyDestination spyDest;
    protected String destinationName;
    protected String jndiName;
    protected boolean jndiBound;
    protected ObjectName jbossMQService;
    protected Element securityConf;
    protected BasicQueueParameters parameters = new BasicQueueParameters();
    ObjectName expiryDestination;
    protected ObjectName securityManager;

    public ObjectName getDestinationManager() {
        return this.jbossMQService;
    }

    public void setDestinationManager(ObjectName jbossMQService) {
        this.jbossMQService = jbossMQService;
    }

    protected SpyDestination getSpyDest() {
        return this.spyDest;
    }

    public void setSecurityConf(Element securityConf) throws Exception {
        this.log.debug((Object)("Setting securityConf: " + securityConf));
        this.securityConf = securityConf;
    }

    protected Element getSecurityConf() {
        return this.securityConf;
    }

    public void setSecurityManager(ObjectName securityManager) {
        this.securityManager = securityManager;
    }

    protected ObjectName getSecurityManager() {
        return this.securityManager;
    }

    public void createService() throws Exception {
        if (this.parameters.receiversImpl == null) {
            this.parameters.receiversImpl = (Class)this.server.getAttribute(this.jbossMQService, "ReceiversImpl");
        }
        if (this.parameters.recoveryRetries == 0) {
            this.parameters.recoveryRetries = (Integer)this.server.getAttribute(this.jbossMQService, "RecoveryRetries");
        }
    }

    public void startService() throws Exception {
        this.setupSecurityManager();
        this.setupExpiryDestination();
    }

    protected void setupSecurityManager() throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (this.securityManager != null) {
            this.getServer().invoke(this.securityManager, "addDestination", new Object[]{this.spyDest.getName(), this.securityConf}, new String[]{"java.lang.String", "org.w3c.dom.Element"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupExpiryDestination() throws Exception {
        if (this.expiryDestination != null) {
            String jndi = (String)this.getServer().getAttribute(this.expiryDestination, "JNDIName");
            InitialContext ctx = new InitialContext();
            try {
                this.parameters.expiryDestination = (SpyDestination)ctx.lookup(jndi);
            }
            finally {
                ctx.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() throws Exception {
        JMSDestinationManager jmsServer;
        if (this.jndiBound) {
            InitialContext ctx = this.getInitialContext();
            try {
                this.log.info((Object)("Unbinding JNDI name: " + this.jndiName));
                Util.unbind((Context)ctx, (String)this.jndiName);
            }
            finally {
                ctx.close();
            }
            this.jndiName = null;
            this.jndiBound = false;
        }
        if ((jmsServer = (JMSDestinationManager)this.server.getAttribute(this.jbossMQService, "Interceptor")) != null) {
            jmsServer.closeDestination(this.spyDest);
        }
        this.teardownSecurityManager();
    }

    protected void teardownSecurityManager() throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (this.securityManager != null) {
            this.getServer().invoke(this.securityManager, "removeDestination", new Object[]{this.spyDest.getName()}, new String[]{"java.lang.String"});
        }
    }

    protected ObjectName getObjectName(MBeanServer server, ObjectName name) throws MalformedObjectNameException {
        this.destinationName = name.getKeyProperty("name");
        if (this.destinationName == null || this.destinationName.length() == 0) {
            throw new MalformedObjectNameException("Property 'name' not provided");
        }
        this.log = Logger.getLogger((String)(this.getClass().getName() + "." + this.destinationName));
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setJNDIName(String name) throws Exception {
        if (this.spyDest == null) {
            this.jndiName = name;
            return;
        }
        if (name == null) {
            throw new InvalidAttributeValueException("Destination JNDI names can not be null");
        }
        InitialContext ic = this.getInitialContext();
        try {
            if (this.jndiName != null && this.jndiBound) {
                Util.unbind((Context)ic, (String)this.jndiName);
                this.jndiName = null;
                this.jndiBound = false;
            }
            Util.rebind((Context)ic, (String)name, (Object)this.spyDest);
            this.jndiName = name;
            this.jndiBound = true;
        }
        finally {
            ic.close();
        }
        this.log.info((Object)("Bound to JNDI name: " + this.jndiName));
    }

    protected InitialContext getInitialContext() throws NamingException {
        InitialContext ic = new InitialContext();
        return ic;
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    public abstract MessageCounter[] getMessageCounter();

    public abstract MessageStatistics[] getMessageStatistics() throws Exception;

    public String listMessageCounter() {
        MessageCounter[] counter = this.getMessageCounter();
        if (counter == null) {
            return null;
        }
        String ret = "<table width=\"100%\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\"><tr><th>Type</th><th>Name</th><th>Subscription</th><th>Durable</th><th>Count</th><th>CountDelta</th><th>Depth</th><th>DepthDelta</th><th>Last Add</th></tr>";
        for (int i = 0; i < counter.length; ++i) {
            String data = counter[i].getCounterAsString();
            StringTokenizer token = new StringTokenizer(data, ",");
            ret = ret + "<tr bgcolor=\"#" + (i % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\">";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            String value = token.nextToken();
            if (value.equalsIgnoreCase("0")) {
                value = "-";
            }
            ret = ret + "<td>" + value + "</td>";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            value = token.nextToken();
            if (value.equalsIgnoreCase("0")) {
                value = "-";
            }
            ret = ret + "<td>" + value + "</td>";
            ret = ret + "<td>" + token.nextToken() + "</td>";
            ret = ret + "</tr>";
        }
        ret = ret + "</table>";
        return ret;
    }

    public void resetMessageCounter() {
        MessageCounter[] counter = this.getMessageCounter();
        if (counter == null) {
            return;
        }
        for (int i = 0; i < counter.length; ++i) {
            counter[i].resetCounter();
        }
    }

    public String listMessageCounterHistory() {
        MessageCounter[] counter = this.getMessageCounter();
        if (counter == null) {
            return null;
        }
        String ret = "";
        for (int i = 0; i < counter.length; ++i) {
            ret = ret + (counter[i].getDestinationTopic() ? "Topic '" : "Queue '");
            ret = ret + counter[i].getDestinationName() + "'";
            if (counter[i].getDestinationSubscription() != null) {
                ret = ret + "Subscription '" + counter[i].getDestinationSubscription() + "'";
            }
            ret = ret + "<table width=\"100%\" border=\"1\" cellpadding=\"1\" cellspacing=\"1\"><tr><th>Date</th>";
            for (int j = 0; j < 24; ++j) {
                ret = ret + "<th width=\"4%\">" + j + "</th>";
            }
            ret = ret + "<th>Total</th></tr>";
            StringTokenizer tokens = new StringTokenizer(counter[i].getHistoryAsString(), ",\n");
            int days = Integer.parseInt(tokens.nextToken());
            for (int j = 0; j < days; ++j) {
                ret = ret + "<tr bgcolor=\"#" + (j % 2 == 0 ? "FFFFFF" : "F0F0F0") + "\">";
                ret = ret + "<td>" + tokens.nextToken() + "</td>";
                int total = 0;
                for (int k = 0; k < 24; ++k) {
                    int value = Integer.parseInt(tokens.nextToken().trim());
                    if (value == -1) {
                        ret = ret + "<td></td>";
                        continue;
                    }
                    ret = ret + "<td>" + value + "</td>";
                    total += value;
                }
                ret = ret + "<td>" + total + "</td></tr>";
            }
            ret = ret + "</table><br><br>";
        }
        return ret;
    }

    public void resetMessageCounterHistory() {
        MessageCounter[] counter = this.getMessageCounter();
        if (counter == null) {
            return;
        }
        for (int i = 0; i < counter.length; ++i) {
            counter[i].resetHistory();
        }
    }

    public void setMessageCounterHistoryDayLimit(int days) {
        if (days < -1) {
            days = -1;
        }
        this.parameters.messageCounterHistoryDayLimit = days;
        if (this.getState() != 3) {
            return;
        }
        MessageCounter[] counter = this.getMessageCounter();
        for (int i = 0; i < counter.length; ++i) {
            counter[i].setHistoryLimit(days);
        }
    }

    public int getMessageCounterHistoryDayLimit() {
        return this.parameters.messageCounterHistoryDayLimit;
    }

    public int getMaxDepth() {
        return this.parameters.maxDepth;
    }

    public void setMaxDepth(int depth) {
        this.parameters.maxDepth = depth;
    }

    public boolean getInMemory() {
        return this.parameters.inMemory;
    }

    public void setInMemory(boolean mode) {
        this.parameters.inMemory = mode;
    }

    public int getRedeliveryLimit() {
        return this.parameters.redeliveryLimit;
    }

    public void setRedeliveryLimit(int limit) {
        this.parameters.redeliveryLimit = limit;
    }

    public long getRedeliveryDelay() {
        return this.parameters.redeliveryDelay;
    }

    public void setRedeliveryDelay(long rDelay) {
        this.parameters.redeliveryDelay = rDelay;
    }

    public Class getReceiversImpl() {
        return this.parameters.receiversImpl;
    }

    public void setReceiversImpl(Class clazz) {
        if (clazz != null && !Receivers.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " is not a Receivers implementation");
        }
        this.parameters.receiversImpl = clazz;
    }

    public int getRecoveryRetries() {
        return this.parameters.recoveryRetries;
    }

    public void setRecoveryRetries(int retries) {
        this.parameters.recoveryRetries = retries;
    }

    public ObjectName getExpiryDestination() {
        return this.expiryDestination;
    }

    public void setExpiryDestination(ObjectName expiryDestination) {
        this.expiryDestination = expiryDestination;
    }
}

