/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.builders;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.managed.ManagedObjectCreator;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.profileservice.management.builders.ServiceManagedObject;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.system.metadata.ServiceMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FakeConnectionFactoryDeployerManagedObjectBuilder
implements ManagedObjectCreator {
    private static Logger log = Logger.getLogger(FakeConnectionFactoryDeployerManagedObjectBuilder.class);
    private Map<String, String> propertyNameMappings = new HashMap<String, String>();

    public Map<String, String> getPropertyNameMappings() {
        return this.propertyNameMappings;
    }

    public void setPropertyNameMappings(Map<String, String> mangedToMBeanNames) {
        for (String key : mangedToMBeanNames.keySet()) {
            String value = mangedToMBeanNames.get(key);
            this.propertyNameMappings.put(value, key);
        }
    }

    public void build(DeploymentUnit unit, Map<String, ManagedObject> map) throws DeploymentException {
        String name = unit.getSimpleName();
        if (name.endsWith("-dsf.xml")) {
            Map attachments = unit.getTransientManagedObjects().getAttachments();
            log.info((Object)(name + " attachments: " + attachments));
            ServiceDeployment service = (ServiceDeployment)unit.getAttachment(ServiceDeployment.class);
            if (service == null) {
                throw new DeploymentException("Failed to find ServiceDeployment in " + unit.getName());
            }
            List services = service.getServices();
            if (services.size() != 1) {
                throw new DeploymentException("Expected only 1 ServiceMetaData but saw " + services.size() + " in " + unit.getName());
            }
            ServiceMetaData dsMetaData = (ServiceMetaData)services.get(0);
            String attachName = ServiceMetaData.class.getName();
            ServiceManagedObject mo = new ServiceManagedObject(attachName, dsMetaData, this.propertyNameMappings);
            map.put(attachName, (ManagedObject)mo);
            attachName = "FakeConnectionFactoryDeployer.datasource-type";
            ManagedObjectImpl typeMO = new ManagedObjectImpl(attachName);
            DefaultFieldsImpl f21 = new DefaultFieldsImpl();
            f21.setName("datasource-type");
            f21.setDescription("The type of the DataSource");
            f21.setMandatory(true);
            f21.setValue((Serializable)((Object)"local-tx-datasource"));
            HashSet<SimpleValue> values = new HashSet<SimpleValue>();
            values.add(SimpleValueSupport.wrap((Serializable)((Object)"local-tx-datasource")));
            values.add(SimpleValueSupport.wrap((Serializable)((Object)"no-tx-datasource")));
            values.add(SimpleValueSupport.wrap((Serializable)((Object)"xa-datasource")));
            f21.setLegalValues(values);
            f21.setMetaType((MetaType)SimpleMetaType.STRING);
            ManagedPropertyImpl dsType = new ManagedPropertyImpl((ManagedObject)typeMO, (Fields)f21);
            typeMO.getProperties().put("datasource-type", dsType);
            map.put(attachName, (ManagedObject)typeMO);
        }
    }
}

