/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.profileservice.management.templates;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import org.jboss.deployers.spi.management.DeploymentTemplate;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.profileservice.management.templates.JmsDestinationTemplateInfo;
import org.jboss.virtual.VirtualFile;

public class JmsDestinationTemplate
implements DeploymentTemplate {
    private DeploymentTemplateInfo info;

    public DeploymentTemplateInfo getInfo() {
        return this.info;
    }

    public void setInfo(DeploymentTemplateInfo info) {
        this.info = info;
    }

    public VirtualFile applyTemplate(VirtualFile root, String deploymentBaseName, DeploymentTemplateInfo values) throws Exception {
        String dsName = deploymentBaseName + "-service.xml";
        URI dsXmlURI = new URI(root.toURI() + dsName);
        File dsXml = new File(dsXmlURI.getPath());
        this.writeTemplate(dsXml, values);
        return root.findChild(dsName);
    }

    public void updateTemplateDeployment(VFSDeployment ctx, DeploymentTemplateInfo values) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTemplate(File dsXml, DeploymentTemplateInfo info) throws Exception {
        JmsDestinationTemplateInfo destinationInfo = (JmsDestinationTemplateInfo)info;
        String destinationType = destinationInfo.getDestinationType();
        JmsDestinationMetaData destination = new JmsDestinationMetaData();
        String jndiName = "" + this.getProperty(info, "JNDIName");
        if ("queue".equals(destinationType)) {
            destination.className = "org.jboss.jms.server.destination.QueueService";
            destination.annotation = "@org.jboss.system.deployers.managed.ManagementObjectClass(code=org.jboss.jms.server.destination.QueueServiceMO)";
            destination.xmbeanDd = "xmdesc/Queue-xmbean.xml";
            destination.jmxName = "jboss.messaging.destination:service=Queue,name=" + jndiName;
        } else if ("topic".equals(destinationType)) {
            destination.className = "org.jboss.jms.server.destination.TopicService";
            destination.annotation = "@org.jboss.system.deployers.managed.ManagementObjectClass(code=org.jboss.jms.server.destination.TopicServiceMO)";
            destination.xmbeanDd = "xmdesc/Topic-xmbean.xml";
            destination.jmxName = "jboss.messaging.destination:service=Topic,name=" + jndiName;
        } else {
            throw new IllegalStateException("Unsupported destination type: " + destinationType);
        }
        ArrayList<JmsAttributeMetaData> attributes = new ArrayList<JmsAttributeMetaData>();
        JmsAttributeMetaData jndiNameMD = new JmsAttributeMetaData("JNDIName", jndiName);
        destination.attribute = attributes;
        attributes.add(jndiNameMD);
        ArrayList<JmsDependencyMetaData> depends = new ArrayList<JmsDependencyMetaData>();
        destination.depends = depends;
        depends.add(new JmsDependencyMetaData("ServerPeer", "jboss.messaging:service=ServerPeer"));
        depends.add(new JmsDependencyMetaData("jboss.messaging:service=PostOffice"));
        JmsDestinationDeployment deployment = new JmsDestinationDeployment();
        deployment.destination = destination;
        Class[] classes = new Class[]{JmsDestinationDeployment.class};
        JAXBContext context = JAXBContext.newInstance((Class[])classes);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        JAXBElement root = new JAXBElement(new QName("server"), JmsDestinationDeployment.class, null, (Object)deployment);
        FileWriter fw = null;
        try {
            fw = new FileWriter(dsXml);
            marshaller.marshal((Object)root, (Writer)fw);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    private Object getProperty(DeploymentTemplateInfo info, String propName) {
        Map propsInfo = info.getProperties();
        ManagedProperty prop = (ManagedProperty)propsInfo.get(propName);
        if (prop == null) {
            throw new IllegalStateException("Property " + propName + " not found.");
        }
        Object value = prop.getValue();
        if (value instanceof MetaValue) {
            if (prop.getMetaType().isComposite()) {
                throw new IllegalArgumentException("Unable to handle composite: " + prop);
            }
            if (prop.getMetaType().isSimple()) {
                SimpleValue sv = (SimpleValue)SimpleValue.class.cast(value);
                value = sv.getValue();
            }
        }
        return value;
    }

    public static class JmsDependencyMetaData {
        @XmlAttribute(name="optional-attribute-name")
        String attribute;
        @XmlValue
        String value;

        public JmsDependencyMetaData() {
        }

        public JmsDependencyMetaData(String value) {
            this.value = value;
        }

        public JmsDependencyMetaData(String attribute, String value) {
            this.attribute = attribute;
            this.value = value;
        }
    }

    public static class JmsAttributeMetaData {
        @XmlAttribute
        String name;
        @XmlValue
        String value;

        public JmsAttributeMetaData() {
        }

        public JmsAttributeMetaData(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class JmsDestinationMetaData {
        @XmlAttribute(name="code")
        String className;
        @XmlAttribute(name="name")
        String jmxName;
        @XmlAttribute(name="xmbean-dd")
        String xmbeanDd;
        @XmlElement
        String annotation;
        public List<JmsAttributeMetaData> attribute;
        public List<JmsDependencyMetaData> depends;
    }

    @XmlRootElement(name="server")
    public static class JmsDestinationDeployment {
        @XmlElement(name="mbean")
        public JmsDestinationMetaData destination;
    }
}

