/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import junit.framework.TestCase;
import org.jboss.jsfunit.analysis.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInterfaceTestCase
extends TestCase {
    protected String className = null;
    protected String jsfElement = null;
    protected Class<?> classClass = null;

    public AbstractInterfaceTestCase(String name, String jsfElement, String className) {
        super(name);
        this.jsfElement = jsfElement;
        this.className = className;
    }

    public void runTest() {
        this.testClassLoadable();
        this.testInterface();
    }

    public void testClassLoadable() {
        this.getClassExtensionClass();
    }

    public void testInterface() {
        Class[] constraints = new Class[]{this.getClassToExtend()};
        if (!new ClassUtils().isAssignableFrom(constraints, this.getClassExtensionClass())) {
            AbstractInterfaceTestCase.fail((String)(this.jsfElement + " '" + this.className + "' needs to implement " + this.getClassToExtend()));
        }
    }

    protected void setClassName(String className) {
        this.className = className;
    }

    private Class<?> getClassExtensionClass() {
        if (this.classClass == null) {
            this.classClass = new ClassUtils().loadClass(this.className, this.jsfElement);
        }
        return this.classClass;
    }

    protected abstract Class<?> getClassToExtend();
}

