/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.webapp.UIComponentTag;
import javax.faces.webapp.UIComponentTagBase;
import javax.xml.parsers.DocumentBuilder;
import junit.framework.TestCase;
import net.sf.maventaglib.checker.Tag;
import net.sf.maventaglib.checker.TagAttribute;
import net.sf.maventaglib.checker.Tld;
import net.sf.maventaglib.checker.TldParser;
import org.jboss.jsfunit.analysis.DefaultStreamProvider;
import org.jboss.jsfunit.analysis.StreamProvider;
import org.jboss.jsfunit.analysis.TagAttributeTypesImpl;
import org.jboss.jsfunit.analysis.UniqueTagAttributesImpl;
import org.jboss.jsfunit.analysis.UniqueTagNamesImpl;
import org.jboss.jsfunit.analysis.util.ClassUtils;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTldTestCase
extends TestCase {
    protected Map<String, Tld> tldsByPath = new HashMap<String, Tld>();
    protected Map<String, Document> documentsByPath = new HashMap<String, Document>();
    private StreamProvider streamProvider;
    private Map<Tag, Tld> tldsByTag = new HashMap<Tag, Tld>();
    private Map<Tag, Class> tagClassesByTag = new HashMap<Tag, Class>();

    public AbstractTldTestCase(Set<String> tldPaths) {
        this(tldPaths, new DefaultStreamProvider());
    }

    public AbstractTldTestCase(final String tldPath) {
        this((Set<String>)new HashSet<String>(){
            {
                this.add(tldPath);
            }
        });
    }

    AbstractTldTestCase(Set<String> tldPaths, StreamProvider streamProvider) {
        if (streamProvider == null) {
            throw new IllegalArgumentException("stream provider is null");
        }
        if (tldPaths == null || tldPaths.size() == 0) {
            throw new IllegalArgumentException("tldPaths was null or empty. At least one TLD needed");
        }
        this.streamProvider = streamProvider;
        this.parseResources(tldPaths);
    }

    private void parseResources(Set<String> tldPaths) {
        DocumentBuilder builder = ParserUtils.getDocumentBuilder();
        for (String tldPath : tldPaths) {
            Tld tld;
            Document document;
            String xml = ParserUtils.getXml(tldPath, this.streamProvider);
            try {
                document = builder.parse(new ByteArrayInputStream(xml.getBytes()));
                tld = TldParser.parse((Document)document, (String)tldPath);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not parse document '" + tldPath + "'\n" + xml, e);
            }
            this.tldsByPath.put(tldPath, tld);
            this.documentsByPath.put(tldPath, document);
            this.trim(tldPath, tld);
        }
    }

    private void trim(String tldPath, Tld tld) {
        if (tld.getName() == null || "".equals(tld.getName().trim())) {
            throw new RuntimeException("TLD in " + tldPath + " has no name");
        }
        tld.setName(tld.getName().trim());
        for (Tag tag : tld.getTags()) {
            this.tldsByTag.put(tag, tld);
            if (tag.getName() == null || "".equals(tag.getName().trim())) {
                throw new RuntimeException("tag in " + tldPath + " has no name");
            }
            tag.setName(tag.getName().trim());
            String tagClass = tag.getTagClass();
            Class clazz = new ClassUtils().loadClass(tagClass, "tag-class");
            this.tagClassesByTag.put(tag, clazz);
            for (TagAttribute attribute : tag.getAttributes()) {
                String type = attribute.getAttributeType();
                type = type == null ? type : type.trim();
            }
        }
    }

    public void testInheritance() {
        for (Tag tag : this.tagClassesByTag.keySet()) {
            Class clazz = this.tagClassesByTag.get(tag);
            Class[] constraints = new Class[]{UIComponentTag.class, UIComponentTagBase.class};
            if (new ClassUtils().isAssignableFrom(constraints, clazz)) continue;
            Tld tld = this.tldsByTag.get(tag);
            AbstractTldTestCase.fail((String)(clazz + " configured in TLD '" + tld.getName() + "' needs to be a " + UIComponentTag.class.getName() + " or a " + UIComponentTagBase.class.getName()));
        }
    }

    public void testTagAttributeTypes() {
        new TagAttributeTypesImpl(this.tldsByPath.values(), this.tagClassesByTag).test();
    }

    public void testUniqueTagNames() {
        new UniqueTagNamesImpl(this.tldsByPath).test();
    }

    public void testUniqueTagAttributes() {
        new UniqueTagAttributesImpl(this.tldsByPath.values()).test();
    }
}

