/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import junit.framework.TestCase;
import org.jboss.jsfunit.analysis.DefaultStreamProvider;
import org.jboss.jsfunit.analysis.StreamProvider;
import org.jboss.jsfunit.analysis.ViewConfigReconciler;
import org.jboss.jsfunit.analysis.ViewParser;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractViewTestCase
extends TestCase {
    protected Map<String, Document> viewsByPath;
    protected Map<String, Document> configByPath;
    protected ViewParser parser;

    public AbstractViewTestCase(Set<String> absolutePaths, Set<String> recursivePaths, Set<String> configPaths) {
        this(absolutePaths, recursivePaths, configPaths, new DefaultStreamProvider());
    }

    public AbstractViewTestCase(Set<String> absolutePaths, Set<String> recursivePaths, final String configPath) {
        this(absolutePaths, recursivePaths, (Set<String>)new HashSet<String>(){
            {
                this.add(configPath);
            }
        });
    }

    public AbstractViewTestCase(Set<String> absolutePaths, final String recursivePath, final String configPath) {
        this(absolutePaths, (Set<String>)new HashSet<String>(){
            {
                this.add(recursivePath);
            }
        }, (Set<String>)new HashSet<String>(){
            {
                this.add(configPath);
            }
        });
    }

    public AbstractViewTestCase(final String absolutePath, final String recursivePath, final String configPath) {
        this((Set<String>)new HashSet<String>(){
            {
                this.add(absolutePath);
            }
        }, (Set<String>)new HashSet<String>(){
            {
                this.add(recursivePath);
            }
        }, (Set<String>)new HashSet<String>(){
            {
                this.add(configPath);
            }
        });
    }

    AbstractViewTestCase(Set<String> absolutePaths, Set<String> recursivePaths, Set<String> configPaths, StreamProvider streamProvider) {
        if (streamProvider == null) {
            throw new IllegalArgumentException("stream provider is null");
        }
        if (absolutePaths == null && recursivePaths == null) {
            throw new IllegalArgumentException("absolutePaths and recursivePaths are null ... " + AbstractViewTestCase.class.getName() + " needs at least one path to a view");
        }
        if (absolutePaths == null) {
            absolutePaths = new HashSet<String>();
        }
        if (recursivePaths == null) {
            recursivePaths = new HashSet<String>();
        }
        if (configPaths == null) {
            throw new IllegalArgumentException("configPaths is null");
        }
        if (configPaths.size() == 0) {
            throw new IllegalArgumentException("configPaths empty, must supply at least one");
        }
        HashSet<String> allPaths = new HashSet<String>(absolutePaths);
        for (String path : recursivePaths) {
            AbstractViewTestCase.explode(new File(path), allPaths, "xhtml");
            AbstractViewTestCase.explode(new File(path), allPaths, "jsp");
        }
        if (allPaths.size() == 0) {
            throw new IllegalArgumentException("No view templates found. At least one must be specified");
        }
        this.viewsByPath = new HashMap<String, Document>();
        this.configByPath = new HashMap<String, Document>();
        this.parser = new ViewParser();
        this.parseResources(allPaths, streamProvider, this.viewsByPath);
        this.parseResources(configPaths, streamProvider, this.configByPath);
        for (String path : this.viewsByPath.keySet()) {
            this.parser.parse(this.viewsByPath.get(path), path);
        }
    }

    private void parseResources(Set<String> allPaths, StreamProvider streamProvider, Map<String, Document> documentsByPath) {
        DocumentBuilder builder = ParserUtils.getDocumentBuilder();
        for (String path : allPaths) {
            InputStream stream = null;
            try {
                System.out.println("parsing " + path);
                stream = streamProvider.getInputStream(path);
                documentsByPath.put(path, builder.parse(stream));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not parse file '" + path + "'", e);
            }
            finally {
                if (stream == null) continue;
                try {
                    stream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not close stream for " + path);
                }
            }
        }
    }

    public static void explode(File file, Set<String> files, String ext) {
        if (file.isDirectory()) {
            String[] children = file.list();
            for (int i = 0; i < children.length; ++i) {
                AbstractViewTestCase.explode(new File(file, children[i]), files, ext);
            }
        } else if (file.getName().endsWith(ext)) {
            files.add(file.getAbsolutePath());
        }
    }

    public void testActions() {
        new ViewConfigReconciler(null, this.parser.getActions(), this.configByPath).reconcileActions();
    }

    public void testActionListeners() {
        new ViewConfigReconciler(this.parser.getActionListeners(), null, this.configByPath).reconcileActionListeners();
    }
}

