/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.jsfunit.analysis.ActionListenerTestCase;
import org.jboss.jsfunit.analysis.DefaultRenderkitTestCase;
import org.jboss.jsfunit.analysis.DefaultStreamProvider;
import org.jboss.jsfunit.analysis.ElResolverTestCase;
import org.jboss.jsfunit.analysis.NavigationHandlerTestCase;
import org.jboss.jsfunit.analysis.PropertyResolverTestCase;
import org.jboss.jsfunit.analysis.StateManagerTestCase;
import org.jboss.jsfunit.analysis.StreamProvider;
import org.jboss.jsfunit.analysis.VariableResolverTestCase;
import org.jboss.jsfunit.analysis.ViewHandlerTestCase;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationTestSuite
extends TestSuite
implements Test {
    private StreamProvider streamProvider = null;

    public ApplicationTestSuite(String name) {
        super(name);
    }

    public Test getSuite(String configFilePath, Node applicationNode, List<String> configFilePathList) {
        String defaultRenderkit;
        String stateManager;
        String viewHandler;
        String navigationHandler;
        TestSuite suite = new TestSuite();
        suite.setName(this.getName());
        if (configFilePath == null || "".equals(configFilePath.trim()) || applicationNode == null) {
            return suite;
        }
        String actionListener = this.getActionListener(applicationNode, configFilePath);
        if (actionListener != null) {
            suite.addTest((Test)new ActionListenerTestCase(actionListener, actionListener));
        }
        if ((navigationHandler = this.getNavigationHandler(applicationNode, configFilePath)) != null) {
            suite.addTest((Test)new NavigationHandlerTestCase(navigationHandler, navigationHandler));
        }
        if ((viewHandler = this.getViewHandler(applicationNode, configFilePath)) != null) {
            suite.addTest((Test)new ViewHandlerTestCase(viewHandler, viewHandler));
        }
        if ((stateManager = this.getStateManager(applicationNode, configFilePath)) != null) {
            suite.addTest((Test)new StateManagerTestCase(stateManager, stateManager));
        }
        if ((defaultRenderkit = this.getDefaultRenderkit(applicationNode, configFilePath)) != null) {
            List<String> tempList = configFilePathList;
            if (tempList == null) {
                tempList = new ArrayList<String>();
                tempList.add(configFilePath);
            }
            suite.addTest((Test)new DefaultRenderkitTestCase(defaultRenderkit, tempList));
        }
        Map<String, String> elResolvers = this.getElResolvers(applicationNode, configFilePath);
        for (String elResolverId : elResolvers.keySet()) {
            String elResolverClassName = elResolvers.get(elResolverId);
            suite.addTest((Test)new ElResolverTestCase(elResolverId, elResolverClassName));
        }
        Map<String, String> propertyResolvers = this.getPropertyResolvers(applicationNode, configFilePath);
        for (String propertyResolverId : propertyResolvers.keySet()) {
            String propertyResolverClassName = propertyResolvers.get(propertyResolverId);
            suite.addTest((Test)new PropertyResolverTestCase(propertyResolverId, propertyResolverClassName));
        }
        Map<String, String> variableResolvers = this.getVariableResolvers(applicationNode, configFilePath);
        for (String variableResolverId : variableResolvers.keySet()) {
            String variableResolverClassName = variableResolvers.get(variableResolverId);
            suite.addTest((Test)new VariableResolverTestCase(variableResolverId, variableResolverClassName));
        }
        return suite;
    }

    private String getActionListener(Node applicationNode, String configFilePath) {
        String result = null;
        String xpathActionListener = "/faces-config/application/action-listener";
        String xpathActionListenerClassName = "./text()";
        NodeList actionListeners = ParserUtils.query(applicationNode, xpathActionListener, configFilePath);
        switch (actionListeners.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                Node actionListener = actionListeners.item(0);
                String name = ParserUtils.querySingle(actionListener, xpathActionListenerClassName, configFilePath);
                if (name == null || name.trim().length() <= 0) break;
                result = name.trim();
                break;
            }
            default: {
                throw new RuntimeException("only one action listener node may be specified in an application node");
            }
        }
        return result;
    }

    private String getNavigationHandler(Node applicationNode, String configFilePath) {
        String result = null;
        String xpathNavigationHandler = "/faces-config/application/navigation-handler";
        String xpathNavigationHandlerClassName = "./text()";
        NodeList navigationHandlers = ParserUtils.query(applicationNode, xpathNavigationHandler, configFilePath);
        switch (navigationHandlers.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                Node navigationHandler = navigationHandlers.item(0);
                String name = ParserUtils.querySingle(navigationHandler, xpathNavigationHandlerClassName, configFilePath);
                if (name == null || name.trim().length() <= 0) break;
                result = name.trim();
                break;
            }
            default: {
                throw new RuntimeException("only one navigation handler node may be specified in an application node");
            }
        }
        return result;
    }

    private String getViewHandler(Node applicationNode, String configFilePath) {
        String result = null;
        String xpathViewHandler = "/faces-config/application/view-handler";
        String xpathViewHandlerClassName = "./text()";
        NodeList viewHandlers = ParserUtils.query(applicationNode, xpathViewHandler, configFilePath);
        switch (viewHandlers.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                Node viewHandler = viewHandlers.item(0);
                String name = ParserUtils.querySingle(viewHandler, xpathViewHandlerClassName, configFilePath);
                if (name == null || name.trim().length() <= 0) break;
                result = name.trim();
                break;
            }
            default: {
                throw new RuntimeException("only one view handler node may be specified in an application node");
            }
        }
        return result;
    }

    private String getStateManager(Node applicationNode, String configFilePath) {
        String result = null;
        String xpathStateManager = "/faces-config/application/state-manager";
        String xpathStateManagerClassName = "./text()";
        NodeList stateManagers = ParserUtils.query(applicationNode, xpathStateManager, configFilePath);
        switch (stateManagers.getLength()) {
            case 0: {
                break;
            }
            case 1: {
                Node stateManager = stateManagers.item(0);
                String name = ParserUtils.querySingle(stateManager, xpathStateManagerClassName, configFilePath);
                if (name == null || name.trim().length() <= 0) break;
                result = name.trim();
                break;
            }
            default: {
                throw new RuntimeException("only one state manager node may be specified in an application node");
            }
        }
        return result;
    }

    private String getDefaultRenderkit(Node applicationNode, String configFilePath) {
        String result = null;
        String xpathDefaultRenderkitId = "./default-render-kit-id/text()";
        String name = ParserUtils.querySingle(applicationNode, xpathDefaultRenderkitId, configFilePath);
        if (name != null && name.trim().length() > 0) {
            result = name.trim();
        }
        return result;
    }

    private Map<String, String> getElResolvers(Node applicationNode, String configFilePath) {
        HashMap<String, String> result = new HashMap<String, String>();
        String xpathElResolver = "/faces-config/application/el-resolver";
        String xpathElResolverClassName = "./text()";
        String xpathElResolverIdAttributeName = "id";
        NodeList elResolvers = ParserUtils.query(applicationNode, xpathElResolver, configFilePath);
        for (int i = 0; i < elResolvers.getLength(); ++i) {
            Node elResolver = elResolvers.item(i);
            NamedNodeMap elAttributes = elResolver.getAttributes();
            Node elResolverIdAttribute = elAttributes.getNamedItem(xpathElResolverIdAttributeName);
            String elResolverId = null;
            if (elResolverIdAttribute != null) {
                elResolverId = elResolverIdAttribute.getTextContent();
            }
            String className = ParserUtils.querySingle(elResolver, xpathElResolverClassName, configFilePath);
            if (elResolverId != null) {
                result.put(elResolverId, className);
                continue;
            }
            result.put(className, className);
        }
        return result;
    }

    private Map<String, String> getPropertyResolvers(Node applicationNode, String configFilePath) {
        HashMap<String, String> result = new HashMap<String, String>();
        String xpathPropertyResolver = "/faces-config/application/property-resolver";
        String xpathPropertyResolverClassName = "./text()";
        String xpathPropertyResolverIdAttributeName = "id";
        NodeList propertyResolvers = ParserUtils.query(applicationNode, xpathPropertyResolver, configFilePath);
        for (int i = 0; i < propertyResolvers.getLength(); ++i) {
            Node propertyResolver = propertyResolvers.item(i);
            NamedNodeMap propertyAttributes = propertyResolver.getAttributes();
            Node propertyResolverIdAttribute = propertyAttributes.getNamedItem(xpathPropertyResolverIdAttributeName);
            String propertyResolverId = null;
            if (propertyResolverIdAttribute != null) {
                propertyResolverId = propertyResolverIdAttribute.getTextContent();
            }
            String className = ParserUtils.querySingle(propertyResolver, xpathPropertyResolverClassName, configFilePath);
            if (propertyResolverId != null) {
                result.put(propertyResolverId, className);
                continue;
            }
            result.put(className, className);
        }
        return result;
    }

    private Map<String, String> getVariableResolvers(Node applicationNode, String configFilePath) {
        HashMap<String, String> result = new HashMap<String, String>();
        String xpathVariableResolver = "/faces-config/application/variable-resolver";
        String xpathVariableResolverClassName = "./text()";
        String xpathVariableResolverIdAttributeName = "id";
        NodeList variableResolvers = ParserUtils.query(applicationNode, xpathVariableResolver, configFilePath);
        for (int i = 0; i < variableResolvers.getLength(); ++i) {
            Node variableResolver = variableResolvers.item(i);
            NamedNodeMap variableAttributes = variableResolver.getAttributes();
            Node variableResolverIdAttribute = variableAttributes.getNamedItem(xpathVariableResolverIdAttributeName);
            String variableResolverId = null;
            if (variableResolverIdAttribute != null) {
                variableResolverId = variableResolverIdAttribute.getTextContent();
            }
            String className = ParserUtils.querySingle(variableResolver, xpathVariableResolverClassName, configFilePath);
            if (variableResolverId != null) {
                result.put(variableResolverId, className);
                continue;
            }
            result.put(className, className);
        }
        return result;
    }

    public StreamProvider getStreamProvider() {
        if (this.streamProvider == null) {
            this.streamProvider = new DefaultStreamProvider();
        }
        return this.streamProvider;
    }

    public void setStreamProvider(StreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }
}

