/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import javax.faces.component.UIComponent;
import org.jboss.jsfunit.analysis.AbstractInterfaceTestCase;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentTestCase
extends AbstractInterfaceTestCase {
    protected Node componentNode = null;
    protected String configFilePath = null;

    public ComponentTestCase(String name, Node componentNode, String configFilePath) {
        super(name, "Component", null);
        this.componentNode = componentNode;
        this.configFilePath = configFilePath;
    }

    @Override
    protected Class<?> getClassToExtend() {
        return UIComponent.class;
    }

    @Override
    public void runTest() {
        this.testComponentTypeAttribute();
        this.testComponentClassAttribute();
        this.setClassName(this.getComponentClassName());
        super.runTest();
    }

    private String getComponentClassName() {
        String result = null;
        String xpathComponentClassName = "./component-class/text()";
        result = ParserUtils.querySingle(this.componentNode, xpathComponentClassName, this.configFilePath);
        return result;
    }

    public void testComponentTypeAttribute() {
        String xpath = "./component-type/text()";
        String name = ParserUtils.querySingle(this.componentNode, xpath, this.configFilePath);
        ComponentTestCase.assertNotNull((String)("could not determine name of " + this.componentNode.getNodeName() + " in " + this.configFilePath), (Object)name);
        ComponentTestCase.assertFalse((String)("could not determine name of " + this.componentNode.getNodeName() + " in " + this.configFilePath), (boolean)"".equals(name.trim()));
    }

    public void testComponentClassAttribute() {
        String className = this.getComponentClassName();
        ComponentTestCase.assertNotNull((String)("could not determine class of " + this.componentNode.getNodeName() + " in " + this.configFilePath), (Object)className);
        ComponentTestCase.assertFalse((String)("could not determine class of " + this.componentNode.getNodeName() + " in " + this.configFilePath), (boolean)"".equals(className.trim()));
    }
}

