/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.jsfunit.analysis.ConfigFileTestSuite;
import org.jboss.jsfunit.analysis.DefaultStreamProvider;
import org.jboss.jsfunit.analysis.StreamProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigFilesTestSuite
extends TestSuite {
    private StreamProvider streamProvider = null;

    public ConfigFilesTestSuite(String name) {
        super(name);
    }

    public Test getSuite(List<String> configFilePathList) {
        System.out.println("start building dynamic suite");
        long timeStart = System.currentTimeMillis();
        if (configFilePathList == null) {
            throw new RuntimeException("Invalid input: null");
        }
        TestSuite suite = new TestSuite();
        suite.setName(this.getName() + "_" + ConfigFilesTestSuite.class.getSimpleName());
        for (String singleConfigFilePath : configFilePathList) {
            ConfigFileTestSuite subSuite = new ConfigFileTestSuite(singleConfigFilePath);
            subSuite.setStreamProvider(this.getStreamProvider());
            suite.addTest(subSuite.getSuite(singleConfigFilePath, configFilePathList));
        }
        long timeStop = System.currentTimeMillis();
        double timeInSeconds = (double)(timeStop - timeStart) / 1000.0;
        System.out.println("stop building dynamic suite (duration: " + timeInSeconds + " seconds) adding " + suite.countTestCases() + " testcases.");
        return suite;
    }

    public StreamProvider getStreamProvider() {
        if (this.streamProvider == null) {
            this.streamProvider = new DefaultStreamProvider();
        }
        return this.streamProvider;
    }

    public void setStreamProvider(StreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }
}

