/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.jboss.jsfunit.analysis.util.ClassUtils;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedBeanTestCase
extends TestCase {
    protected String configFilePath = null;
    protected String managedBeanName = null;
    protected String managedBeanClassName = null;
    protected Node managedBeanNode;
    protected Class<?> managedBeanClass = null;
    private static final List<String> SCOPES = new ArrayList<String>(){
        {
            this.add("none");
            this.add("request");
            this.add("session");
            this.add("application");
        }
    };

    public ManagedBeanTestCase(String name, String configFilePath, String managedBeanName, Node managedBeanNode) {
        super(name);
        this.configFilePath = configFilePath;
        this.managedBeanName = managedBeanName;
        this.managedBeanNode = managedBeanNode;
    }

    public void runTest() {
        this.testNameAttribute();
        this.testClassAttribute();
        this.testScopeAttribute();
        this.testClassLoadable();
        this.testValidScope();
        this.testSerializableInterface();
    }

    public void testNameAttribute() {
        String xpath = "./managed-bean-name/text()";
        String name = ParserUtils.querySingle(this.managedBeanNode, xpath, this.configFilePath);
        ManagedBeanTestCase.assertNotNull((String)("could not determine name of " + this.managedBeanNode.getNodeName() + " in " + this.configFilePath), (Object)name);
        ManagedBeanTestCase.assertFalse((String)("could not determine name of " + this.managedBeanNode.getNodeName() + " in " + this.configFilePath), (boolean)"".equals(name.trim()));
    }

    public void testClassAttribute() {
        String className = this.getManagedBeanClassName();
        ManagedBeanTestCase.assertNotNull((String)("could not determine class of " + this.managedBeanNode.getNodeName() + " in " + this.configFilePath), (Object)className);
        ManagedBeanTestCase.assertFalse((String)("could not determine class of " + this.managedBeanNode.getNodeName() + " in " + this.configFilePath), (boolean)"".equals(className.trim()));
    }

    public void testScopeAttribute() {
        String scope = this.getScope();
        ManagedBeanTestCase.assertNotNull((String)("could not determine scope of " + this.managedBeanNode.getNodeName() + " in " + this.configFilePath), (Object)scope);
        ManagedBeanTestCase.assertFalse((String)("could not determine scope of " + this.managedBeanNode.getNodeName() + " in " + this.configFilePath), (boolean)"".equals(scope.trim()));
    }

    public void testClassLoadable() {
        this.getManagedBeanClass();
    }

    public void testValidScope() {
        String scope = this.getScope();
        ManagedBeanTestCase.assertTrue((String)("Managed bean '" + this.managedBeanName + "' in " + this.configFilePath + " has an invalid scope '" + scope + "'"), (boolean)SCOPES.contains(scope));
    }

    public void testSerializableInterface() {
        String scope = this.getScope();
        if ("session".equals(scope) || "application".equals(scope)) {
            ManagedBeanTestCase.assertTrue((String)("Managed bean '" + this.managedBeanName + "' is in " + scope + " scope, so it needs to implement " + Serializable.class), (boolean)Serializable.class.isAssignableFrom(this.getManagedBeanClass()));
        }
    }

    public void testDuplicateProperties() {
        HashMap<String, Node> properties = new HashMap<String, Node>();
        String xpath = "/faces-config/managed-bean";
        String xpathBeanName = "./managed-bean-name/text()";
        String xpathProperty = "./managed-property";
        String xpathPropertyName = "./property-name/text()";
        NodeList managedBeans = ParserUtils.query(this.managedBeanNode, xpath, this.configFilePath);
        for (int i = 0; i < managedBeans.getLength(); ++i) {
            Node bean = managedBeans.item(i);
            String name = ParserUtils.querySingle(bean, xpathBeanName, this.configFilePath);
            if (name != null && name.trim().length() > 0) {
                if (!this.managedBeanName.equals(name.trim())) continue;
                NodeList managedProperties = ParserUtils.query(bean, xpathProperty, this.configFilePath);
                for (int j = 0; j < managedProperties.getLength(); ++j) {
                    Node property = managedProperties.item(j);
                    String propertyName = ParserUtils.querySingle(property, xpathPropertyName, this.configFilePath);
                    if (propertyName != null && propertyName.trim().length() > 0) {
                        if (properties.containsKey(propertyName = propertyName.trim())) {
                            ManagedBeanTestCase.fail((String)("managed bean '" + this.managedBeanName + "' in " + this.configFilePath + " has a duplicate property named " + propertyName));
                            continue;
                        }
                        properties.put(propertyName, property);
                        continue;
                    }
                    ManagedBeanTestCase.fail((String)("managed bean '" + name + "' property without 'property-name' configured"));
                }
                continue;
            }
            ManagedBeanTestCase.fail((String)"managed bean without 'managed-bean-name' configured");
        }
    }

    private String getManagedBeanClassName() {
        String xpath = "./managed-bean-class/text()";
        if (this.managedBeanClassName == null) {
            this.managedBeanClassName = ParserUtils.querySingle(this.managedBeanNode, xpath, this.configFilePath);
            if (this.managedBeanClassName != null) {
                this.managedBeanClassName = this.managedBeanClassName.trim();
            }
        }
        return this.managedBeanClassName;
    }

    private String getScope() {
        String xpath = "./managed-bean-scope/text()";
        String scope = ParserUtils.querySingle(this.managedBeanNode, xpath, this.configFilePath);
        return scope;
    }

    private Class<?> getManagedBeanClass() {
        if (this.managedBeanClass == null) {
            this.managedBeanClass = new ClassUtils().loadClass(this.getManagedBeanClassName(), "managed bean");
        }
        return this.managedBeanClass;
    }
}

