/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.lang.reflect.Method;
import java.util.HashSet;
import junit.framework.TestCase;
import org.jboss.jsfunit.analysis.util.ClassUtils;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedPropertyTestCase
extends TestCase {
    protected String configFilePath = null;
    protected String managedBeanName = null;
    protected String managedBeanClassName = null;
    protected String managedPropertyName = null;
    protected Class<?> managedBeanClass = null;
    protected Node managedPropertyNode;

    public ManagedPropertyTestCase(String name, String configFilePath, String managedBeanName, String managedBeanClassName, String managedPropertyName, Node managedPropertyNode) {
        super(name);
        this.configFilePath = configFilePath;
        this.managedBeanName = managedBeanName;
        this.managedBeanClassName = managedBeanClassName;
        this.managedPropertyName = managedPropertyName;
        this.managedPropertyNode = managedPropertyNode;
    }

    public void runTest() {
        this.testPropertyAccessors();
        this.testMapDuplicateKeys();
    }

    public void testPropertyAccessors() {
        String setter = this.createAccessorName("set");
        String getter1 = this.createAccessorName("get");
        String getter2 = this.createAccessorName("is");
        if (!this.hasMethod(setter, 1, this.getManagedBeanClass())) {
            ManagedPropertyTestCase.fail((String)("The managed bean '" + this.managedBeanName + "' has a managed property called '" + this.managedPropertyName + "', but " + this.managedBeanClassName + " has no method " + setter + "(?)"));
        }
        if (!this.hasMethod(getter1, 0, this.getManagedBeanClass()) && !this.hasMethod(getter2, 0, this.getManagedBeanClass())) {
            ManagedPropertyTestCase.fail((String)("The managed bean '" + this.managedBeanName + "' has a managed property called '" + this.managedPropertyName + "', but " + this.managedBeanClassName + " has neither a method " + getter1 + "() nor a method " + getter2 + "()"));
        }
    }

    public void testMapDuplicateKeys() {
        String xpathMapEntries = "./map-entries";
        String xpathMapEntryKey = "./map-entry/key";
        NodeList nodeList = ParserUtils.query(this.managedPropertyNode, xpathMapEntries, this.configFilePath);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList keys = ParserUtils.query(nodeList.item(i), xpathMapEntryKey, this.configFilePath);
            HashSet<String> keyNames = new HashSet<String>();
            for (int j = 0; j < keys.getLength(); ++j) {
                Node firstChild = keys.item(j).getFirstChild();
                ManagedPropertyTestCase.assertNotNull((Object)firstChild);
                String textContent = firstChild.getTextContent();
                ManagedPropertyTestCase.assertTrue((String)("Managed Bean '" + this.managedBeanName + "' has a managed Map property with a duplicate key '" + textContent + "'"), (!keyNames.contains(textContent) ? 1 : 0) != 0);
                keyNames.add(textContent);
            }
        }
    }

    private String createAccessorName(String prefix) {
        StringBuffer result = new StringBuffer(prefix);
        result.append(this.managedPropertyName.substring(0, 1).toUpperCase());
        result.append(this.managedPropertyName.substring(1, this.managedPropertyName.length()));
        return result.toString();
    }

    private Class<?> getManagedBeanClass() {
        if (this.managedBeanClass == null) {
            this.managedBeanClass = new ClassUtils().loadClass(this.managedBeanClassName, "managed bean");
        }
        return this.managedBeanClass;
    }

    private boolean hasMethod(String methodName, int numberOfParameters, Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (!(methodName.equals(methods[i].getName()) & methods[i].getParameterTypes().length == numberOfParameters)) continue;
            return true;
        }
        return this.hasMethod(methodName, numberOfParameters, clazz.getSuperclass());
    }
}

