/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import junit.framework.TestCase;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.w3c.dom.Node;

public class NavigationRuleTestCase
extends TestCase {
    protected String configFilePath = null;
    protected Node navigationRuleNode;

    public NavigationRuleTestCase(String name, String configFilePath, Node navigationRuleNode) {
        super(name);
        this.configFilePath = configFilePath;
        this.navigationRuleNode = navigationRuleNode;
    }

    public void runTest() {
        this.testFromViewId();
    }

    public void testFromViewId() {
        try {
            String fromViewId = this.getFromViewId();
            if (fromViewId != null && fromViewId.trim().length() == 0) {
                NavigationRuleTestCase.fail((String)"'from-view-id' must not be configured with empty content");
            }
        }
        catch (RuntimeException re) {
            NavigationRuleTestCase.assertTrue((String)re.getMessage(), (boolean)re.getMessage().startsWith("query ./from-view-id/text() returned"));
            NavigationRuleTestCase.fail((String)"'from-view-id' must not be configured more than once for a 'navigation-rule'");
        }
    }

    private String getFromViewId() {
        String xpath = "./from-view-id/text()";
        String fromViewId = ParserUtils.querySingle(this.navigationRuleNode, xpath, this.configFilePath);
        return fromViewId;
    }
}

