/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.jsfunit.analysis.DefaultStreamProvider;
import org.jboss.jsfunit.analysis.NavigationCaseTestCase;
import org.jboss.jsfunit.analysis.NavigationRuleTestCase;
import org.jboss.jsfunit.analysis.StreamProvider;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NavigationRuleTestSuite
extends TestSuite
implements Test {
    private StreamProvider streamProvider = null;

    public NavigationRuleTestSuite(String name) {
        super(name);
    }

    public Test getSuite(String configFilePath, Node navigationRuleNode) {
        TestSuite suite = new TestSuite();
        suite.setName(this.getName());
        String navigationRuleId = this.getNavigationRuleId(configFilePath, navigationRuleNode);
        suite.addTest((Test)new NavigationRuleTestCase("navigationRule_" + navigationRuleId, configFilePath, navigationRuleNode));
        Map<String, Node> navigationCases = this.getNavigationCases(configFilePath, navigationRuleNode);
        for (String navigationcaseId : navigationCases.keySet()) {
            suite.addTest((Test)new NavigationCaseTestCase("navigationCase_" + navigationcaseId, configFilePath, navigationCases.get(navigationcaseId)));
        }
        return suite;
    }

    private Map<String, Node> getNavigationCases(String configFilePath, Node navigationRuleNode) {
        HashMap<String, Node> result = new HashMap<String, Node>();
        String xpathNavigationCase = "./navigation-case";
        String xpathToViewId = "./to-view-id/text()";
        if (navigationRuleNode != null) {
            NodeList navigationCases = ParserUtils.query(navigationRuleNode, xpathNavigationCase, configFilePath);
            for (int i = 0; i < navigationCases.getLength(); ++i) {
                Node navigationCase = navigationCases.item(i);
                String displayName = this.getDisplayName(configFilePath, navigationCase);
                if (displayName != null && displayName.trim().length() > 0) {
                    result.put(displayName, navigationCase);
                    continue;
                }
                String toViewId = ParserUtils.querySingle(navigationCase, xpathToViewId, configFilePath);
                if (toViewId != null && toViewId.trim().length() > 0) {
                    result.put(toViewId.trim(), navigationCase);
                    continue;
                }
                throw new RuntimeException("navigation case without to-view-id");
            }
        }
        return result;
    }

    private String getNavigationRuleId(String configFilePath, Node domNode) {
        String result = this.getDisplayName(configFilePath, domNode);
        if (result != null) {
            result = result.trim();
        } else {
            result = this.getFromViewId(configFilePath, domNode);
            if (result != null) {
                result = result.trim();
            }
        }
        return result;
    }

    private String getDisplayName(String configFilePath, Node domNode) {
        String xpath = "./display-name/text()";
        String result = null;
        if (domNode != null && (result = ParserUtils.querySingle(domNode, xpath, configFilePath)) != null) {
            result = result.trim();
        }
        return result;
    }

    private String getFromViewId(String configFilePath, Node domNode) {
        String xpath = "./from-view-id/text()";
        String result = null;
        if (domNode != null) {
            result = ParserUtils.querySingle(domNode, xpath, configFilePath);
            result = result != null ? result.trim() : "*";
        }
        return result;
    }

    public StreamProvider getStreamProvider() {
        if (this.streamProvider == null) {
            this.streamProvider = new DefaultStreamProvider();
        }
        return this.streamProvider;
    }

    public void setStreamProvider(StreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }
}

