/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.util.Collection;
import java.util.LinkedList;
import junit.framework.Assert;
import net.sf.maventaglib.checker.Tag;
import net.sf.maventaglib.checker.TagAttribute;
import net.sf.maventaglib.checker.Tld;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UniqueTagAttributesImpl {
    private Collection<Tld> tlds;

    public UniqueTagAttributesImpl(Collection<Tld> tlds) {
        this.tlds = tlds;
    }

    public void test() {
        for (Tld tld : this.tlds) {
            for (Tag tag : tld.getTags()) {
                this.scrutinizeAttributes(tld, tag);
            }
        }
    }

    private void scrutinizeAttributes(Tld tld, Tag tag) {
        LinkedList<String> attributeNames = new LinkedList<String>();
        for (TagAttribute attribute : tag.getAttributes()) {
            String name = attribute.getAttributeName();
            if (name == null || "".equals(name.trim())) {
                Assert.fail((String)(tld.getName() + ":" + tag.getName() + " has an empty attribute name"));
            } else if (attributeNames.contains(name)) {
                Assert.fail((String)("Attribute " + name + " in " + tld.getName() + ":" + tag.getName() + " is duplicated."));
            }
            attributeNames.add(name);
        }
    }
}

