/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewParser {
    private Map<String, List<String>> actionListeners = new HashMap<String, List<String>>();
    private Map<String, List<String>> actions = new HashMap<String, List<String>>();

    public Map<String, List<String>> getActionListeners() {
        return this.actionListeners;
    }

    public Map<String, List<String>> getActions() {
        return this.actions;
    }

    private void addActionListener(String path, String el) {
        List<String> list = this.actionListeners.get(path);
        if (list == null) {
            list = new LinkedList<String>();
            this.actionListeners.put(path, list);
        }
        list.add(el);
    }

    private void addAction(String path, String el) {
        List<String> list = this.actions.get(path);
        if (list == null) {
            list = new LinkedList<String>();
            this.actions.put(path, list);
        }
        list.add(el);
    }

    public void parse(Node node, String path) {
        new ParserUtils();
        NodeList bindings = ParserUtils.query(node, "//actionListener/@binding", path);
        for (int i = 0; i < bindings.getLength(); ++i) {
            this.addActionListener(path, bindings.item(i).getNodeValue());
        }
        new ParserUtils();
        NodeList actionListeners = ParserUtils.query(node, "*//@actionListener", path);
        for (int i = 0; i < actionListeners.getLength(); ++i) {
            this.addActionListener(path, actionListeners.item(i).getNodeValue());
        }
        new ParserUtils();
        NodeList actions = ParserUtils.query(node, "*//@action", path);
        for (int i = 0; i < actions.getLength(); ++i) {
            this.addAction(path, actions.item(i).getNodeValue());
        }
    }
}

