/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis.el;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NotFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.jboss.jsfunit.analysis.el.ELBundle;
import org.jboss.jsfunit.analysis.el.Filters;
import org.jboss.jsfunit.analysis.el.MultiFileELExpressionIterator;
import org.jboss.jsfunit.analysis.el.SkipExpressionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELIterFactory {
    public static final Iterator<ELBundle> EMPTY_ITER = new Iterator<ELBundle>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public ELBundle next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    public static Iterable<ELBundle> getIterable(final File baseDir, final IOFileFilter fileFilter, final Collection<SkipExpressionSpec> toSkip) {
        return new Iterable<ELBundle>(){

            @Override
            public Iterator<ELBundle> iterator() {
                return ELIterFactory.getIterator(baseDir, fileFilter, toSkip);
            }
        };
    }

    public static Iterable<ELBundle> getIterable(final File baseDir, final IOFileFilter fileFilter, final IOFileFilter dirFilter, final Collection<SkipExpressionSpec> toSkip) {
        return new Iterable<ELBundle>(){

            @Override
            public Iterator<ELBundle> iterator() {
                return ELIterFactory.getIterator(baseDir, fileFilter, dirFilter, toSkip);
            }
        };
    }

    public static Iterator<ELBundle> getIterator(File baseDir, IOFileFilter fileFilter, Collection<SkipExpressionSpec> toSkip) {
        return ELIterFactory.getIterator(baseDir, fileFilter, Filters.IGNORE_HIDDEN_AND_CVS_FILTER, toSkip);
    }

    public static Iterator<ELBundle> getIterator(File baseDir, IOFileFilter fileFilter, IOFileFilter dirFilter, Collection<SkipExpressionSpec> toSkip) {
        OrFileFilter alwaysSkipFiles = new OrFileFilter();
        HashSet<Pattern> alwaysSkipPatterns = new HashSet<Pattern>();
        HashMap<IOFileFilter, Pattern> sometimesSkipPatterns = new HashMap<IOFileFilter, Pattern>();
        for (SkipExpressionSpec spec : toSkip) {
            IOFileFilter ff = spec.getFileFilter();
            Pattern ef = spec.getExpressionFilter();
            if (ff == null) {
                if (ef == null) {
                    return EMPTY_ITER;
                }
                alwaysSkipPatterns.add(ef);
                continue;
            }
            if (ef == null) {
                alwaysSkipFiles.addFileFilter(ff);
                continue;
            }
            sometimesSkipPatterns.put(ff, ef);
        }
        AndFileFilter compositeFilter = new AndFileFilter(fileFilter, (IOFileFilter)new NotFileFilter((IOFileFilter)alwaysSkipFiles));
        Iterator baseIter = FileUtils.iterateFiles((File)baseDir, (IOFileFilter)compositeFilter, (IOFileFilter)dirFilter);
        return new MultiFileELExpressionIterator(ELIterFactory.asFileIter(baseIter), alwaysSkipPatterns, sometimesSkipPatterns);
    }

    private static Iterator<File> asFileIter(Iterator<?> baseIter) {
        return baseIter;
    }
}

