/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis.el;

import de.odysseus.el.ExpressionFactoryImpl;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import javax.faces.event.ActionEvent;
import junit.framework.TestCase;
import org.jboss.jsfunit.analysis.el.ELBundle;
import org.jboss.jsfunit.analysis.el.JSFUnitELContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELTestCase
extends TestCase {
    private final ELBundle expression;
    private final Map<String, Class<?>> beanMap;

    public ELTestCase(ELBundle expression, Map<String, Class<?>> beanMap) {
        super(expression.getName());
        this.expression = expression;
        this.beanMap = beanMap;
    }

    public void testExpression() {
        Object outputObj;
        String el = this.expression.getExpression();
        ExpressionFactoryImpl factory = new ExpressionFactoryImpl();
        JSFUnitELContext context = new JSFUnitELContext(this.beanMap, (ExpressionFactory)factory);
        try {
            ValueExpression e = factory.createValueExpression((ELContext)context, el, Object.class);
            outputObj = e.getValue((ELContext)context);
        }
        catch (PropertyNotFoundException pnfe) {
            this.elFail(pnfe);
            return;
        }
        catch (ELException ee) {
            this.elFail(ee);
            return;
        }
        if (outputObj instanceof Method) {
            Method method = (Method)outputObj;
            if ("action".equals(this.expression.getAttr())) {
                ELTestCase.assertEquals(String.class, method.getReturnType());
                ELTestCase.assertEquals((int)0, (int)method.getParameterTypes().length);
            } else if ("actionListener".equals(this.expression.getAttr())) {
                ELTestCase.assertEquals(Void.TYPE, method.getReturnType());
                Class<?>[] params = method.getParameterTypes();
                ELTestCase.assertEquals((int)1, (int)params.length);
                ELTestCase.assertEquals(ActionEvent.class, params[0]);
            }
        } else if (!(outputObj instanceof Class)) {
            this.resolveFail();
        }
    }

    private void resolveFail() {
        String el = this.expression.getExpression();
        File file = this.expression.getFile();
        int start = this.expression.getStartIndex();
        ELTestCase.fail((String)String.format("%s contains EL %s beginning at char %s, but this could not be resolved to a class or method.", file, el, start));
    }

    private void elFail(Throwable t) {
        String el = this.expression.getExpression();
        File file = this.expression.getFile();
        int start = this.expression.getStartIndex();
        ELTestCase.fail((String)(String.format("Error for EL %s in file %s beginning at char %s: ", el, file, start) + t.getClass() + ": " + t.getMessage()));
    }

    public void runTest() {
        this.testExpression();
    }
}

