/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jsfunit.analysis.util;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.jsfunit.analysis.DefaultStreamProvider;
import org.jboss.jsfunit.analysis.StreamProvider;
import org.jboss.jsfunit.analysis.util.ParserUtils;
import org.jboss.jsfunit.analysis.util.ResourceUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigUtils {
    private StreamProvider streamProvider = null;
    private List<String> configFilePaths = new ArrayList<String>();
    private Map<String, Document> configFileDoms = new HashMap<String, Document>();

    public boolean isConfigured(ConfigItemType elementType, String elementName, boolean includeClassPath) {
        Document configFile;
        String configFilePath;
        boolean result = false;
        Iterator<String> cachedDomNames = this.getConfigFileDoms().keySet().iterator();
        while (cachedDomNames.hasNext() && !result) {
            configFilePath = cachedDomNames.next();
            configFile = this.getConfigFileDoms().get(configFilePath);
            if (!this.isConfiguredConfigItemType(elementType, elementName, configFile, configFilePath)) continue;
            result = true;
        }
        if (!result) {
            Iterator<String> configFilePaths = this.getConfigFilePaths().iterator();
            while (configFilePaths.hasNext() && !result) {
                configFilePath = configFilePaths.next();
                if (this.getConfigFileDoms().keySet().contains(configFilePath)) continue;
                configFile = ParserUtils.getDomDocument(configFilePath, this.getStreamProvider());
                this.getConfigFileDoms().put(configFilePath, configFile);
                if (!this.isConfiguredConfigItemType(elementType, elementName, configFile, configFilePath)) continue;
                result = true;
            }
        }
        if (!result && includeClassPath) {
            List<InputStream> classPathConfigFiles = ResourceUtils.getClassPathResourcesAsStreams("META-INF/faces-config.xml");
            Iterator<InputStream> classPathConfigFilesStreams = classPathConfigFiles.iterator();
            while (classPathConfigFilesStreams.hasNext() && !result) {
                InputStream classPathConfigFilesStream = classPathConfigFilesStreams.next();
                Document configFile2 = ParserUtils.getDomDocument(classPathConfigFilesStream, classPathConfigFilesStream.toString());
                if (!this.isConfiguredConfigItemType(elementType, elementName, configFile2, classPathConfigFilesStream.toString())) continue;
                result = true;
            }
        }
        return result;
    }

    public boolean isConfiguredConfigItemType(ConfigItemType elementType, String elementName, Document configFile, String configFilePath) {
        boolean result = false;
        switch (elementType) {
            case RENDER_KIT: {
                result = this.extractRenderkitIdsDefined(configFile, configFilePath).contains(elementName);
                break;
            }
        }
        return result;
    }

    public List<String> extractRenderkitIdsDefined(Document configFile, String configFilePath) {
        ArrayList<String> result = new ArrayList<String>();
        String xpathRenderkit = "//render-kit";
        String xpathRenderkitId = "./render-kit-id/text()";
        NodeList renderkits = ParserUtils.query(configFile, xpathRenderkit, configFilePath);
        for (int i = 0; i < renderkits.getLength(); ++i) {
            Node renderkit = renderkits.item(i);
            String id = ParserUtils.querySingle(renderkit, xpathRenderkitId, configFilePath);
            if (id != null && id.trim().length() > 0) {
                result.add(id);
                continue;
            }
            result.add("default");
        }
        return result;
    }

    public List<String> getConfigFilePaths() {
        return this.configFilePaths;
    }

    public void setConfigFilePaths(List<String> configFilePaths) {
        this.configFilePaths = configFilePaths;
    }

    public Map<String, Document> getConfigFileDoms() {
        return this.configFileDoms;
    }

    public void setConfigFileDoms(Map<String, Document> configFileDoms) {
        this.configFileDoms = configFileDoms;
    }

    public StreamProvider getStreamProvider() {
        if (this.streamProvider == null) {
            this.streamProvider = new DefaultStreamProvider();
        }
        return this.streamProvider;
    }

    public void setStreamProvider(StreamProvider streamProvider) {
        this.streamProvider = streamProvider;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConfigItemType {
        RENDER_KIT;

    }
}

