/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logbridge;

import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.jboss.logbridge.LogBridgeHandler;

public final class LogNotificationListener
implements NotificationListener {
    private LogBridgeHandler logBridgeHandler;
    private MBeanServer mBeanServer;
    private ObjectName loggingMBeanName;
    private static final Logger log = Logger.getLogger(LogNotificationListener.class);

    public LogBridgeHandler getLogBridgeHandler() {
        return this.logBridgeHandler;
    }

    public void setLogBridgeHandler(LogBridgeHandler logBridgeHandler) {
        this.logBridgeHandler = logBridgeHandler;
    }

    public MBeanServer getMBeanServer() {
        return this.mBeanServer;
    }

    public void setMBeanServer(MBeanServer mBeanServer) {
        this.mBeanServer = mBeanServer;
    }

    public String getLoggingMBeanName() {
        return this.loggingMBeanName.toString();
    }

    public void setLoggingMBeanName(String loggingMBeanName) throws MalformedObjectNameException {
        this.loggingMBeanName = new ObjectName(loggingMBeanName);
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        this.logBridgeHandler.updateLoggers();
    }

    public void start() throws InstanceNotFoundException {
        log.info((Object)("Adding notification listener for logging mbean \"" + this.loggingMBeanName + "\" to server " + this.mBeanServer));
        this.mBeanServer.addNotificationListener(this.loggingMBeanName, this, null, null);
        this.logBridgeHandler.updateLoggers();
    }

    public void stop() throws ListenerNotFoundException, InstanceNotFoundException {
        this.mBeanServer.removeNotificationListener(this.loggingMBeanName, this);
    }
}

